/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.ClientSessionOptions;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.session.ClientSession;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.SessionAwareMethodInterceptor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class MongoDatabaseFactorySupport<C>
implements MongoDatabaseFactory {
    private final C mongoClient;
    private final String databaseName;
    private final boolean mongoInstanceCreated;
    private PersistenceExceptionTranslator exceptionTranslator;
    @Nullable
    private WriteConcern writeConcern;

    protected MongoDatabaseFactorySupport(C mongoClient, String databaseName, boolean mongoInstanceCreated, PersistenceExceptionTranslator exceptionTranslator) {
        Assert.notNull(mongoClient, (String)"MongoClient must not be null");
        Assert.hasText((String)databaseName, (String)"Database name must not be empty");
        Assert.isTrue((boolean)databaseName.matches("[^/\\\\.$\"\\s]+"), (String)"Database name must not contain slashes, dots, spaces, quotes, or dollar signs");
        this.mongoClient = mongoClient;
        this.databaseName = databaseName;
        this.mongoInstanceCreated = mongoInstanceCreated;
        this.exceptionTranslator = exceptionTranslator;
    }

    public void setExceptionTranslator(PersistenceExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator;
    }

    @Override
    public PersistenceExceptionTranslator getExceptionTranslator() {
        return this.exceptionTranslator;
    }

    public void setWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
    }

    @Override
    public MongoDatabase getMongoDatabase() throws DataAccessException {
        return this.getMongoDatabase(this.getDefaultDatabaseName());
    }

    @Override
    public MongoDatabase getMongoDatabase(String dbName) throws DataAccessException {
        Assert.hasText((String)dbName, (String)"Database name must not be empty");
        MongoDatabase db = this.doGetMongoDatabase(dbName);
        if (this.writeConcern == null) {
            return db;
        }
        return db.withWriteConcern(this.writeConcern);
    }

    protected abstract MongoDatabase doGetMongoDatabase(String var1);

    public void destroy() throws Exception {
        if (this.mongoInstanceCreated) {
            this.closeClient();
        }
    }

    @Override
    public MongoDatabaseFactory withSession(com.mongodb.client.ClientSession session) {
        return new ClientSessionBoundMongoDbFactory(session, this);
    }

    protected abstract void closeClient();

    protected C getMongoClient() {
        return this.mongoClient;
    }

    protected String getDefaultDatabaseName() {
        return this.databaseName;
    }

    static final class ClientSessionBoundMongoDbFactory
    implements MongoDatabaseFactory {
        private final com.mongodb.client.ClientSession session;
        private final MongoDatabaseFactory delegate;

        public ClientSessionBoundMongoDbFactory(com.mongodb.client.ClientSession session, MongoDatabaseFactory delegate) {
            this.session = session;
            this.delegate = delegate;
        }

        @Override
        public MongoDatabase getMongoDatabase() throws DataAccessException {
            return this.proxyMongoDatabase(this.delegate.getMongoDatabase());
        }

        @Override
        public MongoDatabase getMongoDatabase(String dbName) throws DataAccessException {
            return this.proxyMongoDatabase(this.delegate.getMongoDatabase(dbName));
        }

        @Override
        public PersistenceExceptionTranslator getExceptionTranslator() {
            return this.delegate.getExceptionTranslator();
        }

        @Override
        public com.mongodb.client.ClientSession getSession(ClientSessionOptions options) {
            return this.delegate.getSession(options);
        }

        @Override
        public MongoDatabaseFactory withSession(com.mongodb.client.ClientSession session) {
            return this.delegate.withSession(session);
        }

        @Override
        public boolean isTransactionActive() {
            return this.session != null && this.session.hasActiveTransaction();
        }

        private MongoDatabase proxyMongoDatabase(MongoDatabase database) {
            return this.createProxyInstance((ClientSession)this.session, database, MongoDatabase.class);
        }

        private MongoDatabase proxyDatabase(ClientSession session, MongoDatabase database) {
            return this.createProxyInstance(session, database, MongoDatabase.class);
        }

        private MongoCollection<?> proxyCollection(ClientSession session, MongoCollection<?> collection) {
            return this.createProxyInstance(session, collection, MongoCollection.class);
        }

        private <T> T createProxyInstance(ClientSession session, T target, Class<T> targetType) {
            ProxyFactory factory = new ProxyFactory();
            factory.setTarget(target);
            factory.setInterfaces(new Class[]{targetType});
            factory.setOpaque(true);
            factory.addAdvice(new SessionAwareMethodInterceptor<MongoDatabase, MongoCollection>(session, target, com.mongodb.client.ClientSession.class, MongoDatabase.class, this::proxyDatabase, MongoCollection.class, this::proxyCollection));
            return targetType.cast(factory.getProxy(target.getClass().getClassLoader()));
        }

        public com.mongodb.client.ClientSession getSession() {
            return this.session;
        }

        public MongoDatabaseFactory getDelegate() {
            return this.delegate;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClientSessionBoundMongoDbFactory that = (ClientSessionBoundMongoDbFactory)o;
            if (!ObjectUtils.nullSafeEquals((Object)this.session, (Object)that.session)) {
                return false;
            }
            return ObjectUtils.nullSafeEquals((Object)this.delegate, (Object)that.delegate);
        }

        public int hashCode() {
            int result = ObjectUtils.nullSafeHashCode((Object)this.session);
            result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.delegate);
            return result;
        }

        public String toString() {
            return "MongoDatabaseFactorySupport.ClientSessionBoundMongoDbFactory(session=" + this.getSession() + ", delegate=" + this.getDelegate() + ")";
        }
    }
}

