/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoException;
import com.mongodb.MongoServerException;
import com.mongodb.MongoSocketException;
import com.mongodb.bulk.BulkWriteError;
import java.util.Set;
import org.bson.BsonInvalidOperationException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.dao.PermissionDeniedDataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.ClientSessionException;
import org.springframework.data.mongodb.TransientClientSessionException;
import org.springframework.data.mongodb.UncategorizedMongoDbException;
import org.springframework.data.mongodb.util.MongoDbErrorCodes;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

public class MongoExceptionTranslator
implements PersistenceExceptionTranslator {
    public static final MongoExceptionTranslator DEFAULT_EXCEPTION_TRANSLATOR = new MongoExceptionTranslator();
    private static final Set<String> DUPLICATE_KEY_EXCEPTIONS = Set.of("MongoException.DuplicateKey", "DuplicateKeyException");
    private static final Set<String> RESOURCE_FAILURE_EXCEPTIONS = Set.of("MongoException.Network", "MongoSocketException", "MongoException.CursorNotFound", "MongoCursorNotFoundException", "MongoServerSelectionException", "MongoTimeoutException");
    private static final Set<String> RESOURCE_USAGE_EXCEPTIONS = Set.of("MongoInternalException");
    private static final Set<String> DATA_INTEGRITY_EXCEPTIONS = Set.of("WriteConcernException", "MongoWriteException", "MongoBulkWriteException");
    private static final Set<String> SECURITY_EXCEPTIONS = Set.of("MongoCryptException");

    @Nullable
    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.doTranslateException(ex);
    }

    @Nullable
    DataAccessException doTranslateException(RuntimeException ex) {
        if (ex instanceof BsonInvalidOperationException) {
            throw new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof MongoSocketException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        String exception = ClassUtils.getShortName((Class)ClassUtils.getUserClass(ex.getClass()));
        if (DUPLICATE_KEY_EXCEPTIONS.contains(exception)) {
            return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
        }
        if (RESOURCE_FAILURE_EXCEPTIONS.contains(exception)) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (RESOURCE_USAGE_EXCEPTIONS.contains(exception)) {
            return new InvalidDataAccessResourceUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (DATA_INTEGRITY_EXCEPTIONS.contains(exception)) {
            if (ex instanceof MongoServerException) {
                if (MongoDbErrorCodes.isDataDuplicateKeyError(ex)) {
                    return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
                }
                if (ex instanceof MongoBulkWriteException) {
                    MongoBulkWriteException bulkException = (MongoBulkWriteException)ex;
                    for (BulkWriteError writeError : bulkException.getWriteErrors()) {
                        if (!MongoDbErrorCodes.isDuplicateKeyCode(writeError.getCode())) continue;
                        return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            return new DataIntegrityViolationException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof MongoException) {
            MongoException mongoException = (MongoException)((Object)ex);
            int code = mongoException.getCode();
            if (MongoDbErrorCodes.isDuplicateKeyError((Exception)((Object)mongoException))) {
                return new DuplicateKeyException(ex.getMessage(), (Throwable)ex);
            }
            if (MongoDbErrorCodes.isDataAccessResourceError((Exception)((Object)mongoException))) {
                return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
            }
            if (MongoDbErrorCodes.isInvalidDataAccessApiUsageError((Exception)((Object)mongoException)) || code == 12001 || code == 12010 || code == 12011 || code == 12012) {
                return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
            }
            if (MongoDbErrorCodes.isPermissionDeniedError((Exception)((Object)mongoException))) {
                return new PermissionDeniedDataAccessException(ex.getMessage(), (Throwable)ex);
            }
            if (MongoDbErrorCodes.isDataIntegrityViolationError((Exception)((Object)mongoException))) {
                return new DataIntegrityViolationException(mongoException.getMessage(), (Throwable)mongoException);
            }
            if (MongoDbErrorCodes.isClientSessionFailure((Exception)((Object)mongoException))) {
                return this.isTransientFailure((Exception)((Object)mongoException)) ? new TransientClientSessionException(ex.getMessage(), ex) : new ClientSessionException(ex.getMessage(), ex);
            }
            if (ex.getCause() != null && SECURITY_EXCEPTIONS.contains(ClassUtils.getShortName(ex.getCause().getClass()))) {
                return new PermissionDeniedDataAccessException(ex.getMessage(), (Throwable)ex);
            }
            return new UncategorizedMongoDbException(ex.getMessage(), ex);
        }
        if (ex instanceof IllegalStateException) {
            for (StackTraceElement elm : ex.getStackTrace()) {
                if (!elm.getClassName().contains("ClientSession")) continue;
                return new ClientSessionException(ex.getMessage(), ex);
            }
        }
        return null;
    }

    public boolean isTransientFailure(Exception e) {
        Throwable throwable;
        if (e instanceof MongoException) {
            MongoException mongoException = (MongoException)((Object)e);
            return mongoException.hasErrorLabel("TransientTransactionError") || mongoException.hasErrorLabel("UnknownTransactionCommitResult");
        }
        if (e.getCause() != e && (throwable = e.getCause()) instanceof Exception) {
            Exception ex = (Exception)throwable;
            return this.isTransientFailure(ex);
        }
        return false;
    }
}

