/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.mongodb.core.index.IndexDefinition;
import org.springframework.data.mongodb.core.index.IndexFilter;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class TextIndexDefinition
implements IndexDefinition {
    private @Nullable String name;
    private Set<TextIndexedFieldSpec> fieldSpecs = new LinkedHashSet<TextIndexedFieldSpec>();
    private @Nullable String defaultLanguage;
    private @Nullable String languageOverride;
    private @Nullable IndexFilter filter;
    private @Nullable Collation collation;

    TextIndexDefinition() {
    }

    public static TextIndexDefinition forAllFields() {
        return new TextIndexDefinitionBuilder().onAllFields().build();
    }

    public static TextIndexDefinitionBuilder builder() {
        return new TextIndexDefinitionBuilder();
    }

    public void addFieldSpec(TextIndexedFieldSpec fieldSpec) {
        this.fieldSpecs.add(fieldSpec);
    }

    public void addFieldSpecs(Collection<TextIndexedFieldSpec> fieldSpecs) {
        this.fieldSpecs.addAll(fieldSpecs);
    }

    public boolean hasFieldSpec() {
        return !this.fieldSpecs.isEmpty();
    }

    @Override
    public Document getIndexKeys() {
        Document keys = new Document();
        for (TextIndexedFieldSpec fieldSpec : this.fieldSpecs) {
            keys.put(fieldSpec.fieldname, (Object)"text");
        }
        return keys;
    }

    @Override
    public Document getIndexOptions() {
        Document options = new Document();
        if (StringUtils.hasText((String)this.name)) {
            options.put("name", (Object)this.name);
        }
        if (StringUtils.hasText((String)this.defaultLanguage)) {
            options.put("default_language", (Object)this.defaultLanguage);
        }
        if (this.collation != null) {
            options.put("collation", (Object)this.collation.toDocument());
        }
        Document weightsDocument = new Document();
        for (TextIndexedFieldSpec fieldSpec : this.fieldSpecs) {
            if (!fieldSpec.isWeighted()) continue;
            weightsDocument.put(fieldSpec.getFieldname(), (Object)fieldSpec.getWeight());
        }
        if (!weightsDocument.isEmpty()) {
            options.put("weights", (Object)weightsDocument);
        }
        if (StringUtils.hasText((String)this.languageOverride)) {
            options.put("language_override", (Object)this.languageOverride);
        }
        if (this.filter != null) {
            options.put("partialFilterExpression", (Object)this.filter.getFilterObject());
        }
        return options;
    }

    public static class TextIndexDefinitionBuilder {
        private TextIndexDefinition instance = new TextIndexDefinition();
        private static final TextIndexedFieldSpec ALL_FIELDS = new TextIndexedFieldSpec("$**");

        @Contract(value="_ -> this")
        public TextIndexDefinitionBuilder named(String name) {
            this.instance.name = name;
            return this;
        }

        @Contract(value="-> this")
        public TextIndexDefinitionBuilder onAllFields() {
            if (!this.instance.fieldSpecs.isEmpty()) {
                throw new InvalidDataAccessApiUsageException("Cannot add wildcard fieldspect to non empty");
            }
            this.instance.fieldSpecs.add(ALL_FIELDS);
            return this;
        }

        @Contract(value="_ -> this")
        public TextIndexDefinitionBuilder onFields(String ... fieldnames) {
            for (String fieldname : fieldnames) {
                this.onField(fieldname);
            }
            return this;
        }

        @Contract(value="_ -> this")
        public TextIndexDefinitionBuilder onField(String fieldname) {
            return this.onField(fieldname, Float.valueOf(1.0f));
        }

        @Contract(value="_, _ -> this")
        public TextIndexDefinitionBuilder onField(String fieldname, Float weight) {
            if (this.instance.fieldSpecs.contains(ALL_FIELDS)) {
                throw new InvalidDataAccessApiUsageException(String.format("Cannot add %s to field spec for all fields", fieldname));
            }
            this.instance.fieldSpecs.add(new TextIndexedFieldSpec(fieldname, weight));
            return this;
        }

        @Contract(value="_ -> this")
        public TextIndexDefinitionBuilder withDefaultLanguage(String language) {
            this.instance.defaultLanguage = language;
            return this;
        }

        @Contract(value="_ -> this")
        public TextIndexDefinitionBuilder withLanguageOverride(String fieldname) {
            if (StringUtils.hasText((String)this.instance.languageOverride)) {
                throw new InvalidDataAccessApiUsageException(String.format("Cannot set language override on %s as it is already defined on %s", fieldname, this.instance.languageOverride));
            }
            this.instance.languageOverride = fieldname;
            return this;
        }

        @Contract(value="_ -> this")
        public TextIndexDefinitionBuilder partial(@Nullable IndexFilter filter) {
            this.instance.filter = filter;
            return this;
        }

        @Contract(value="-> this")
        public TextIndexDefinitionBuilder withSimpleCollation() {
            this.instance.collation = Collation.simple();
            return this;
        }

        @Contract(value="-> new")
        public TextIndexDefinition build() {
            return this.instance;
        }
    }

    public static class TextIndexedFieldSpec {
        private final String fieldname;
        private final Float weight;

        public TextIndexedFieldSpec(String fieldname) {
            this(fieldname, Float.valueOf(1.0f));
        }

        public TextIndexedFieldSpec(String fieldname, @Nullable Float weight) {
            Assert.hasText((String)fieldname, (String)"Text index field cannot be blank");
            this.fieldname = fieldname;
            this.weight = Float.valueOf(weight != null ? weight.floatValue() : 1.0f);
        }

        public String getFieldname() {
            return this.fieldname;
        }

        public Float getWeight() {
            return this.weight;
        }

        public boolean isWeighted() {
            return this.weight.compareTo(Float.valueOf(1.0f)) != 0;
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode((Object)this.fieldname);
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof TextIndexedFieldSpec)) {
                return false;
            }
            TextIndexedFieldSpec other = (TextIndexedFieldSpec)obj;
            return ObjectUtils.nullSafeEquals((Object)this.fieldname, (Object)other.fieldname);
        }
    }
}

