/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.messaging;

import com.mongodb.CursorType;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Collation;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.QueryMapper;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.messaging.CursorReadingTask;
import org.springframework.data.mongodb.core.messaging.SubscriptionRequest;
import org.springframework.data.mongodb.core.messaging.TailableCursorRequest;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.util.ErrorHandler;

class TailableCursorTask
extends CursorReadingTask<Document, Object> {
    private QueryMapper queryMapper;

    public TailableCursorTask(MongoTemplate template, TailableCursorRequest<?> request, Class<?> targetType, ErrorHandler errorHandler) {
        super(template, request, targetType, errorHandler);
        this.queryMapper = new QueryMapper(template.getConverter());
    }

    @Override
    protected MongoCursor<Document> initCursor(MongoTemplate template, SubscriptionRequest.RequestOptions options, Class<?> targetType) {
        TailableCursorRequest.TailableCursorRequestOptions requestOptions;
        Document filter = new Document();
        Collation collation = null;
        if (options instanceof TailableCursorRequest.TailableCursorRequestOptions && (requestOptions = (TailableCursorRequest.TailableCursorRequestOptions)options).getQuery().isPresent()) {
            Query query = requestOptions.getQuery().get();
            filter.putAll((Map)this.queryMapper.getMappedObject((Bson)query.getQueryObject(), (MongoPersistentEntity)template.getConverter().getMappingContext().getPersistentEntity(targetType.equals(Document.class) ? Object.class : targetType)));
            collation = query.getCollation().map(org.springframework.data.mongodb.core.query.Collation::toMongoCollation).orElse(null);
        }
        FindIterable iterable = template.getCollection(options.getCollectionName()).find((Bson)filter).cursorType(CursorType.TailableAwait).noCursorTimeout(true);
        if (collation != null) {
            iterable = iterable.collation(collation);
        }
        if (!options.maxAwaitTime().isZero()) {
            iterable = iterable.maxAwaitTime(options.maxAwaitTime().toMillis(), TimeUnit.MILLISECONDS);
        }
        return iterable.iterator();
    }
}

