/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.mapping;

import java.util.ArrayList;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.mapping.EntityStateHandler;
import org.springframework.data.neo4j.support.mapping.SourceStateTransmitter;

public class Neo4jEntityFetchHandler {
    private final SourceStateTransmitter<Node> nodeStateTransmitter;
    private final SourceStateTransmitter<Relationship> relationshipStateTransmitter;
    private final EntityStateHandler entityStateHandler;
    private final ConversionService conversionService;

    public Neo4jEntityFetchHandler(EntityStateHandler entityStateHandler, ConversionService conversionService, SourceStateTransmitter<Node> nodeStateTransmitter, SourceStateTransmitter<Relationship> relationshipStateTransmitter) {
        this.conversionService = conversionService;
        this.entityStateHandler = entityStateHandler;
        this.relationshipStateTransmitter = relationshipStateTransmitter;
        this.nodeStateTransmitter = nodeStateTransmitter;
    }

    public Object fetch(Object value, Neo4jPersistentEntity<Object> persistentEntity, Neo4jPersistentProperty property, MappingPolicy policy, Neo4jTemplate template) {
        if (value == null) {
            return value;
        }
        MappingPolicy mappingPolicy = property.getMappingPolicy();
        if (!mappingPolicy.shouldLoad()) {
            return value;
        }
        if (property.getTypeInformation().isCollectionLike()) {
            ArrayList replacement = new ArrayList();
            for (Object inner : (Iterable)value) {
                BeanWrapper innerWrapper = BeanWrapper.create(inner, (ConversionService)this.conversionService);
                Object state = this.entityStateHandler.getPersistentState(inner);
                this.fetchValue((BeanWrapper<Object>)innerWrapper, (PropertyContainer)state, persistentEntity, mappingPolicy, template);
                replacement.add(inner);
            }
            return replacement;
        }
        BeanWrapper innerWrapper = BeanWrapper.create((Object)value, (ConversionService)this.conversionService);
        Object state = this.entityStateHandler.getPersistentState(value);
        this.fetchValue((BeanWrapper<Object>)innerWrapper, (PropertyContainer)state, persistentEntity, mappingPolicy, template);
        return value;
    }

    public void fetchValue(BeanWrapper<Object> wrapper, PropertyContainer source, Neo4jPersistentEntity<Object> persistentEntity, MappingPolicy mappingPolicy, Neo4jTemplate template) {
        if (persistentEntity.isNodeEntity()) {
            this.nodeStateTransmitter.copyPropertiesFrom(wrapper, (Node)source, persistentEntity, mappingPolicy, template);
        }
        if (persistentEntity.isRelationshipEntity()) {
            this.relationshipStateTransmitter.copyPropertiesFrom(wrapper, (Relationship)source, persistentEntity, mappingPolicy, template);
        }
    }
}

