/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.node;

import java.util.HashMap;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexManager;
import org.neo4j.graphdb.index.RelationshipIndex;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.tooling.GlobalGraphOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.neo4j.support.Neo4jTemplate;

public abstract class Neo4jHelper {
    private static final Logger log = LoggerFactory.getLogger(Neo4jHelper.class);

    public static void cleanDb(Neo4jTemplate template) {
        Neo4jHelper.cleanDb(template.getGraphDatabaseService());
    }

    public static void dumpDb(GraphDatabaseService gds) {
        GlobalGraphOperations globalGraphOperations = GlobalGraphOperations.at((GraphDatabaseService)gds);
        for (Node node : globalGraphOperations.getAllNodes()) {
            System.out.println(Neo4jHelper.dump((PropertyContainer)node));
        }
        for (Node node : globalGraphOperations.getAllNodes()) {
            for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                System.out.println(node + "-[:" + rel.getType().name() + " " + Neo4jHelper.dump((PropertyContainer)rel) + "]->" + rel.getEndNode());
            }
        }
    }

    private static String dump(PropertyContainer pc) {
        long id = pc instanceof Node ? ((Node)pc).getId() : ((Relationship)pc).getId();
        try {
            HashMap<String, Object> props = new HashMap<String, Object>();
            for (String prop : pc.getPropertyKeys()) {
                props.put(prop, pc.getProperty(prop));
            }
            return String.format("(%d) %s ", id, props);
        }
        catch (Exception e) {
            return "(" + id + ") " + e.getMessage();
        }
    }

    public static void cleanDb(GraphDatabaseService graphDatabaseService) {
        Neo4jHelper.cleanDb(graphDatabaseService, false);
    }

    public static void cleanDb(GraphDatabaseService graphDatabaseService, boolean includeReferenceNode) {
        try (Transaction tx = graphDatabaseService.beginTx();){
            Neo4jHelper.clearIndex(graphDatabaseService);
            Neo4jHelper.removeNodes(graphDatabaseService, includeReferenceNode);
            tx.success();
        }
    }

    private static void removeNodes(GraphDatabaseService graphDatabaseService, boolean includeReferenceNode) {
        GraphDatabaseAPI api = (GraphDatabaseAPI)graphDatabaseService;
        NodeManager nodeManager = (NodeManager)api.getDependencyResolver().resolveDependency(NodeManager.class);
        GlobalGraphOperations globalGraphOperations = GlobalGraphOperations.at((GraphDatabaseService)graphDatabaseService);
        for (Node node : globalGraphOperations.getAllNodes()) {
            for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                try {
                    if (nodeManager.isDeleted(rel)) continue;
                    rel.delete();
                }
                catch (IllegalStateException ise) {
                    if (ise.getMessage().contains("since it has already been deleted")) continue;
                    throw ise;
                }
            }
            for (Label label : node.getLabels()) {
                node.removeLabel(label);
            }
        }
        for (Node node : globalGraphOperations.getAllNodes()) {
            try {
                if (nodeManager.isDeleted(node)) continue;
                node.delete();
            }
            catch (IllegalStateException ise) {
                if (ise.getMessage().contains("since it has already been deleted")) continue;
                throw ise;
            }
        }
    }

    private static void clearIndex(GraphDatabaseService gds) {
        IndexManager indexManager = gds.index();
        for (String ix : indexManager.nodeIndexNames()) {
            try {
                Index nodeIndex = indexManager.forNodes(ix);
                if (!nodeIndex.isWriteable()) continue;
                nodeIndex.delete();
            }
            catch (Exception e) {
                log.warn("Cannot delete node index " + ix + " " + e.getMessage());
            }
        }
        for (String ix : indexManager.relationshipIndexNames()) {
            try {
                RelationshipIndex relationshipIndex = indexManager.forRelationships(ix);
                if (!relationshipIndex.isWriteable()) continue;
                relationshipIndex.delete();
            }
            catch (Exception e) {
                log.warn("Cannot delete relationship index " + ix + " " + e.getMessage());
            }
        }
    }
}

