/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.conversion;

import java.lang.reflect.ParameterizedType;
import org.neo4j.ogm.MetaData;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MethodInfo;
import org.neo4j.ogm.typeconversion.AttributeConverter;
import org.neo4j.ogm.typeconversion.ConversionCallback;
import org.neo4j.ogm.typeconversion.ProxyAttributeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;

public class MetaDataDrivenConversionService
extends GenericConversionService
implements ConversionCallback {
    private static final Logger logger = LoggerFactory.getLogger(MetaDataDrivenConversionService.class);

    public MetaDataDrivenConversionService(MetaData metaData) {
        metaData.registerConversionCallback((ConversionCallback)this);
        for (ClassInfo classInfo : metaData.persistentEntities()) {
            for (FieldInfo fieldInfo : classInfo.propertyFields()) {
                if (!fieldInfo.hasPropertyConverter()) continue;
                this.addWrappedConverter(fieldInfo.getPropertyConverter());
            }
            for (MethodInfo methodInfo : classInfo.propertyGetters()) {
                if (!methodInfo.hasPropertyConverter()) continue;
                this.addWrappedConverter(methodInfo.getPropertyConverter());
            }
        }
    }

    private void addWrappedConverter(final AttributeConverter attributeConverter) {
        Class targetType;
        if (attributeConverter instanceof ProxyAttributeConverter) {
            return;
        }
        Converter toGraphConverter = new Converter(){

            public Object convert(Object source) {
                return attributeConverter.toGraphProperty(source);
            }
        };
        Converter toEntityConverter = new Converter(){

            public Object convert(Object source) {
                return attributeConverter.toEntityAttribute(source);
            }
        };
        ParameterizedType pt = (ParameterizedType)attributeConverter.getClass().getGenericInterfaces()[0];
        Class sourceType = pt.getActualTypeArguments()[0] instanceof Class ? (Class)pt.getActualTypeArguments()[0] : (Class)((ParameterizedType)pt.getActualTypeArguments()[0]).getActualTypeArguments()[0];
        if (this.canConvert(sourceType, targetType = pt.getActualTypeArguments()[1] instanceof Class ? (Class)pt.getActualTypeArguments()[1] : (Class)((ParameterizedType)pt.getActualTypeArguments()[1]).getActualTypeArguments()[1]) && this.canConvert(targetType, sourceType)) {
            logger.info("Not adding Spring-compatible converter for " + attributeConverter.getClass() + " because one that does the same job has already been registered with the ConversionService.");
        } else {
            this.addConverter(sourceType, targetType, toGraphConverter);
            this.addConverter(targetType, sourceType, toEntityConverter);
        }
    }

    public <T> T convert(Class<T> targetType, Object value) {
        if (value == null) {
            return null;
        }
        return (T)this.convert(value, targetType);
    }
}

