/*
 * Copyright (c)  [2011-2017] "Pivotal Software, Inc." / "Neo Technology" / "Graph Aware Ltd."
 *
 * This product is licensed to you under the Apache License, Version 2.0 (the "License").
 * You may not use this product except in compliance with the License.
 *
 * This product may include a number of subcomponents with
 * separate copyright notices and license terms. Your use of the source
 * code for these subcomponents is subject to the terms and
 * conditions of the subcomponent's license, as noted in the LICENSE file.
 *
 */

package org.springframework.data.neo4j.bookmark;

import org.springframework.core.NamedThreadLocal;

/**
 * Helper class to access BookmarkInfo thread local
 *
 * @author Frantisek Hartman
 */
public class BookmarkSupport {

	protected static final ThreadLocal<BookmarkInfo> bookmarkInfoHolder = new NamedThreadLocal<>("Bookmark info");

	public static BookmarkInfo currentBookmarkInfo() {
		return bookmarkInfoHolder.get();
	}
}
