/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.filter;

import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.springframework.data.neo4j.repository.query.filter.FilterBuilder;
import org.springframework.data.repository.query.parser.Part;

class BetweenComparisonBuilder
extends FilterBuilder {
    BetweenComparisonBuilder(Part part, BooleanOperator booleanOperator, Class<?> entityType) {
        super(part, booleanOperator, entityType);
    }

    @Override
    public List<Filter> build(Stack<Object> params) {
        FilterBuilder.NestedAttributes nestedAttributes = this.getNestedAttributes(this.part);
        Object value1 = params.pop();
        Filter gt = new Filter(nestedAttributes.isEmpty() ? this.propertyName() : nestedAttributes.getLeafPropertySegment(), ComparisonOperator.GREATER_THAN_EQUAL, value1);
        gt.setOwnerEntityType(this.entityType);
        gt.setBooleanOperator(this.booleanOperator);
        gt.setNegated(this.isNegated());
        gt.setNestedPath(nestedAttributes.getSegments());
        Object value2 = params.pop();
        Filter lt = new Filter(nestedAttributes.isEmpty() ? this.propertyName() : nestedAttributes.getLeafPropertySegment(), ComparisonOperator.LESS_THAN_EQUAL, value2);
        lt.setOwnerEntityType(this.entityType);
        lt.setBooleanOperator(BooleanOperator.AND);
        lt.setNegated(this.isNegated());
        lt.setNestedPath(nestedAttributes.getSegments());
        return Arrays.asList(gt, lt);
    }
}

