/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.transaction;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.neo4j.ogm.autoindex.MissingIndexException;
import org.neo4j.ogm.exception.ConnectionException;
import org.neo4j.ogm.exception.CypherException;
import org.neo4j.ogm.exception.ResultErrorsException;
import org.neo4j.ogm.exception.ResultProcessingException;
import org.neo4j.ogm.exception.TransactionException;
import org.neo4j.ogm.exception.core.InvalidDepthException;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.exception.core.MetadataException;
import org.neo4j.ogm.exception.core.MissingOperatorException;
import org.neo4j.ogm.exception.core.NotFoundException;
import org.neo4j.ogm.exception.core.TransactionManagerException;
import org.neo4j.ogm.exception.core.UnknownStatementTypeException;
import org.neo4j.ogm.session.Neo4jException;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.TypeMismatchDataAccessException;
import org.springframework.data.neo4j.exception.Neo4jErrorStatusCodes;
import org.springframework.data.neo4j.exception.UncategorizedNeo4jException;
import org.springframework.data.neo4j.transaction.SessionHolder;
import org.springframework.transaction.support.ResourceHolder;
import org.springframework.transaction.support.ResourceHolderSynchronization;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public class SessionFactoryUtils {
    private static final Logger logger = LoggerFactory.getLogger(SessionFactoryUtils.class);

    public static void closeSession(Session session) {
    }

    public static Session getSession(SessionFactory sessionFactory) throws IllegalStateException {
        Assert.notNull((Object)sessionFactory, (String)"No SessionFactory specified");
        SessionHolder sessionHolder = (SessionHolder)((Object)TransactionSynchronizationManager.getResource((Object)sessionFactory));
        if (sessionHolder != null) {
            if (!sessionHolder.isSynchronizedWithTransaction() && TransactionSynchronizationManager.isSynchronizationActive()) {
                sessionHolder.setSynchronizedWithTransaction(true);
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SessionSynchronization(sessionHolder, sessionFactory, false));
            }
            return sessionHolder.getSession();
        }
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            return null;
        }
        Session session = sessionFactory.openSession();
        logger.debug("Registering transaction synchronization for Neo4j Session");
        sessionHolder = new SessionHolder(session);
        sessionHolder.setSynchronizedWithTransaction(true);
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SessionSynchronization(sessionHolder, sessionFactory, true));
        TransactionSynchronizationManager.bindResource((Object)sessionFactory, (Object)((Object)sessionHolder));
        return session;
    }

    public static DataAccessException convertOgmAccessException(RuntimeException ex) {
        if (ex instanceof IllegalStateException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof NotFoundException) {
            return new DataRetrievalFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof InvalidDepthException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof ResultProcessingException) {
            return new DataRetrievalFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof MappingException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof MetadataException) {
            return new TypeMismatchDataAccessException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof UnknownStatementTypeException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof ConnectionException) {
            return new DataAccessResourceFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof MissingOperatorException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof ResultErrorsException) {
            return new DataRetrievalFailureException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof TransactionException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof TransactionManagerException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof MissingIndexException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof Neo4jException) {
            return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
        }
        if (ex instanceof CypherException) {
            String code = ((CypherException)ex).getCode();
            Class<? extends DataAccessException> dae = Neo4jErrorStatusCodes.translate(code);
            if (dae != null) {
                try {
                    Constructor<? extends DataAccessException> constructor = dae.getDeclaredConstructor(String.class, Throwable.class);
                    return constructor.newInstance(ex.getMessage(), ex);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    return null;
                }
            }
            return new UncategorizedNeo4jException(ex.getMessage(), ex);
        }
        return null;
    }

    private static class SessionSynchronization
    extends ResourceHolderSynchronization<SessionHolder, SessionFactory>
    implements Ordered {
        private final boolean newSession;

        SessionSynchronization(SessionHolder sessionHolder, SessionFactory sessionFactory, boolean newSession) {
            super((ResourceHolder)sessionHolder, (Object)sessionFactory);
            this.newSession = newSession;
        }

        public int getOrder() {
            return 900;
        }

        public void flushResource(SessionHolder resourceHolder) {
        }

        protected boolean shouldUnbindAtCompletion() {
            return this.newSession;
        }

        protected boolean shouldReleaseAfterCompletion(SessionHolder resourceHolder) {
            return false;
        }
    }
}

