/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Map;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.util.PagingAndSortingUtils;
import org.springframework.util.Assert;

public class Query {
    private static final String SKIP = "sdnSkip";
    private static final String LIMIT = "sdnLimit";
    private static final String SKIP_LIMIT = " SKIP {sdnSkip} LIMIT {sdnLimit}";
    private static final String ORDER_BY_CLAUSE = " ORDER BY %s";
    private Filters filters;
    private String cypherQuery;
    private Map<String, Object> parameters;
    private String countQuery;

    public Query(Filters filters) {
        Assert.notNull((Object)filters, (String)"Filters must not be null.");
        this.filters = filters;
    }

    public Query(String cypherQuery, Map<String, Object> parameters) {
        Assert.notNull((Object)cypherQuery, (String)"Query must not be null.");
        Assert.notNull(parameters, (String)"Parameters must not be null.");
        this.cypherQuery = this.sanitize(cypherQuery);
        this.parameters = parameters;
    }

    public Query(String cypherQuery, String countQuery, Map<String, Object> parameters) {
        Assert.notNull((Object)cypherQuery, (String)"Query must not be null.");
        Assert.notNull(parameters, (String)"Parameters must not be null.");
        this.cypherQuery = this.sanitize(cypherQuery);
        this.countQuery = this.sanitize(countQuery);
        this.parameters = parameters;
    }

    public boolean isFilterQuery() {
        return this.filters != null;
    }

    public Filters getFilters() {
        return this.filters;
    }

    public String getCypherQuery() {
        return this.cypherQuery;
    }

    public Map<String, ?> getParameters() {
        return this.parameters;
    }

    public String getCountQuery() {
        return this.countQuery;
    }

    public String getCypherQuery(Pageable pageable, boolean forSlicing) {
        String result = this.cypherQuery;
        Sort sort = null;
        if (pageable.isPaged() && pageable.getSort() != Sort.unsorted()) {
            sort = pageable.getSort();
        }
        if (sort != Sort.unsorted()) {
            result = this.addSorting(result, sort);
        }
        result = this.addPaging(result, pageable, forSlicing);
        return result;
    }

    public String getCypherQuery(Sort sort) {
        String result = this.cypherQuery;
        if (sort != Sort.unsorted()) {
            result = this.addSorting(this.cypherQuery, sort);
        }
        return result;
    }

    private String addPaging(String cypherQuery, Pageable pageable, boolean forSlicing) {
        cypherQuery = this.formatBaseQuery(cypherQuery);
        cypherQuery = cypherQuery + SKIP_LIMIT;
        this.parameters.put(SKIP, pageable.getPageNumber() * pageable.getPageSize());
        if (forSlicing) {
            this.parameters.put(LIMIT, pageable.getPageSize() + 1);
        } else {
            this.parameters.put(LIMIT, pageable.getPageSize());
        }
        return cypherQuery;
    }

    private String addSorting(String baseQuery, Sort sort) {
        baseQuery = this.formatBaseQuery(baseQuery);
        if (sort == null) {
            return baseQuery;
        }
        String sortOrder = this.getSortOrder(sort);
        if (sortOrder.isEmpty()) {
            return baseQuery;
        }
        return baseQuery + String.format(ORDER_BY_CLAUSE, sortOrder);
    }

    private String getSortOrder(Sort sort) {
        String result = "";
        for (Sort.Order order : sort) {
            if (!result.isEmpty()) {
                result = result + ", ";
            }
            result = result + order.getProperty() + " " + order.getDirection();
        }
        return result;
    }

    private String formatBaseQuery(String cypherQuery) {
        if ((cypherQuery = cypherQuery.trim()).endsWith(";")) {
            cypherQuery = cypherQuery.substring(0, cypherQuery.length() - 1);
        }
        return cypherQuery;
    }

    public Pagination getPagination(Pageable pageable, boolean forSlicing) {
        Pagination pagination = new Pagination(pageable.getPageNumber(), pageable.getPageSize() + (forSlicing ? 1 : 0));
        pagination.setOffset(Integer.valueOf(pageable.getPageNumber() * pageable.getPageSize()));
        return pagination;
    }

    public SortOrder getSort(Pageable pageable) {
        return PagingAndSortingUtils.convert(pageable.getSort());
    }

    private String sanitize(String cypherQuery) {
        if ((cypherQuery = cypherQuery.trim()).endsWith(";")) {
            cypherQuery = cypherQuery.substring(0, cypherQuery.length() - 1);
        }
        return cypherQuery;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Query{");
        if (this.filters != null) {
            sb.append("filters=").append(this.filters);
        } else {
            sb.append("cypherQuery='").append(this.cypherQuery).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }
}

