/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.filter;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.function.FilterFunction;

final class NativeIdFilterFunction
implements FilterFunction<Object> {
    private final ComparisonOperator operator;
    private final Object value;
    private Filter filter;

    NativeIdFilterFunction(ComparisonOperator operator, Object value) {
        this.operator = operator;
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }

    public String expression(String nodeIdentifier) {
        switch (this.operator) {
            case EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_EQUAL: 
            case IN: {
                return String.format("id(%s) %s $`%s` ", nodeIdentifier, this.operator.getValue(), this.filter.uniqueParameterName());
            }
        }
        throw new IllegalArgumentException("Unsupported comparision operator for an ID attribute.");
    }

    public Map<String, Object> parameters() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.operator.isOneOf(new ComparisonOperator[]{ComparisonOperator.EQUALS, ComparisonOperator.GREATER_THAN, ComparisonOperator.GREATER_THAN_EQUAL, ComparisonOperator.LESS_THAN, ComparisonOperator.LESS_THAN_EQUAL, ComparisonOperator.IN})) {
            map.put(this.filter.uniqueParameterName(), this.filter.getTransformedPropertyValue());
        }
        return map;
    }
}

