/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.event;

import org.apiguardian.api.API;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.core.Ordered;
import org.springframework.data.auditing.IsNewAwareAuditingHandler;
import org.springframework.data.neo4j.repository.event.BeforeBindCallback;
import org.springframework.util.Assert;

@API(status=API.Status.INTERNAL, since="6.0")
public final class AuditingBeforeBindCallback
implements BeforeBindCallback<Object>,
Ordered {
    public static final int NEO4J_AUDITING_ORDER = 100;
    private final ObjectFactory<IsNewAwareAuditingHandler> auditingHandlerFactory;

    public AuditingBeforeBindCallback(ObjectFactory<IsNewAwareAuditingHandler> auditingHandlerFactory) {
        Assert.notNull(auditingHandlerFactory, (String)"IsNewAwareAuditingHandler must not be null!");
        this.auditingHandlerFactory = auditingHandlerFactory;
    }

    @Override
    public Object onBeforeBind(Object entity) {
        return ((IsNewAwareAuditingHandler)this.auditingHandlerFactory.getObject()).markAudited(entity);
    }

    public int getOrder() {
        return 100;
    }
}

