/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.event;

import java.util.Optional;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.neo4j.core.mapping.IdDescription;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.schema.IdGenerator;
import org.springframework.util.Assert;

final class IdPopulator {
    private final Neo4jMappingContext neo4jMappingContext;

    IdPopulator(Neo4jMappingContext neo4jMappingContext) {
        Assert.notNull((Object)neo4jMappingContext, (String)"A mapping context is required.");
        this.neo4jMappingContext = neo4jMappingContext;
    }

    Object populateIfNecessary(Object entity) {
        Neo4jPersistentProperty idProperty;
        Assert.notNull((Object)entity, (String)"Entity may not be null!");
        Neo4jPersistentEntity nodeDescription = (Neo4jPersistentEntity)this.neo4jMappingContext.getRequiredPersistentEntity(entity.getClass());
        IdDescription idDescription = nodeDescription.getIdDescription();
        if (idDescription == null) {
            if (nodeDescription.isRelationshipPropertiesEntity()) {
                return entity;
            }
            throw new IllegalStateException("Cannot persist implicit entity due to missing id property on " + nodeDescription.getUnderlyingClass() + ".");
        }
        if (!idDescription.isExternallyGeneratedId()) {
            return entity;
        }
        PersistentPropertyAccessor propertyAccessor = nodeDescription.getPropertyAccessor(entity);
        if (propertyAccessor.getProperty((PersistentProperty)(idProperty = (Neo4jPersistentProperty)nodeDescription.getRequiredIdProperty())) != null) {
            return entity;
        }
        Optional<String> optionalIdGeneratorRef = idDescription.getIdGeneratorRef();
        IdGenerator idGenerator = optionalIdGeneratorRef.isPresent() ? (IdGenerator)this.neo4jMappingContext.getIdGenerator(optionalIdGeneratorRef.get()).orElseThrow(() -> new IllegalStateException("Id generator named " + (String)optionalIdGeneratorRef.get() + " not found!")) : this.neo4jMappingContext.getOrCreateIdGeneratorOfType(idDescription.getIdGeneratorClass().get());
        propertyAccessor.setProperty((PersistentProperty)idProperty, idGenerator.generateId(nodeDescription.getPrimaryLabel(), entity));
        return propertyAccessor.getBean();
    }
}

