/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.logging.LogFactory;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.core.log.LogAccessor;
import org.springframework.data.domain.Range;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Metrics;
import org.springframework.data.neo4j.core.convert.Neo4jSimpleTypes;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.repository.query.BoundingBox;
import org.springframework.data.neo4j.repository.query.EntityInstanceWithSource;
import org.springframework.data.neo4j.repository.query.Neo4jParameterAccessor;
import org.springframework.data.neo4j.repository.query.Neo4jQueryMethod;
import org.springframework.data.neo4j.repository.query.Neo4jQueryType;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

abstract class Neo4jQuerySupport {
    protected final Neo4jMappingContext mappingContext;
    protected final Neo4jQueryMethod queryMethod;
    protected final Neo4jQueryType queryType;
    static final LogAccessor REPOSITORY_QUERY_LOG = new LogAccessor(LogFactory.getLog(Neo4jQuerySupport.class));

    static Class<?> getDomainType(QueryMethod queryMethod) {
        return queryMethod.getResultProcessor().getReturnedType().getDomainType();
    }

    Neo4jQuerySupport(Neo4jMappingContext mappingContext, Neo4jQueryMethod queryMethod, Neo4jQueryType queryType) {
        Assert.notNull((Object)mappingContext, (String)"The mapping context is required.");
        Assert.notNull((Object)((Object)queryMethod), (String)"Query method must not be null!");
        Assert.notNull((Object)((Object)queryType), (String)"Query type must not be null!");
        this.mappingContext = mappingContext;
        this.queryMethod = queryMethod;
        this.queryType = queryType;
    }

    protected final Neo4jParameterAccessor getParameterAccessor(Object[] actualParameters) {
        return new Neo4jParameterAccessor((Neo4jQueryMethod.Neo4jParameters)this.queryMethod.getParameters(), actualParameters);
    }

    protected final BiFunction<TypeSystem, Record, ?> getMappingFunction(ResultProcessor resultProcessor) {
        BiFunction<TypeSystem, Record, Object> mappingFunction;
        ReturnedType returnedTypeMetadata = resultProcessor.getReturnedType();
        Class returnedType = returnedTypeMetadata.getReturnedType();
        Class domainType = returnedTypeMetadata.getDomainType();
        if (Neo4jSimpleTypes.HOLDER.isSimpleType(returnedType)) {
            mappingFunction = null;
        } else if (returnedTypeMetadata.isProjecting()) {
            BiFunction target = this.mappingContext.getRequiredMappingFunctionFor(domainType);
            mappingFunction = (t, r) -> new EntityInstanceWithSource(target.apply(t, r), (TypeSystem)t, (Record)r);
        } else {
            mappingFunction = this.mappingContext.getRequiredMappingFunctionFor(domainType);
        }
        return mappingFunction;
    }

    protected final List<String> getInputProperties(ResultProcessor resultProcessor) {
        ReturnedType returnedType = resultProcessor.getReturnedType();
        return returnedType.isProjecting() ? returnedType.getInputProperties() : Collections.emptyList();
    }

    final Object convertParameter(Object parameter) {
        return this.convertParameter(parameter, null);
    }

    final Object convertParameter(Object parameter, @Nullable Function<Object, Value> conversionOverride) {
        if (parameter == null) {
            REPOSITORY_QUERY_LOG.warn((CharSequence)"Do not use `null` as a property value for comparison. It will always be false and return an empty result.");
            return Values.NULL;
        }
        if (parameter instanceof Range) {
            return this.convertRange((Range)parameter);
        }
        if (parameter instanceof Distance) {
            return Neo4jQuerySupport.calculateDistanceInMeter((Distance)parameter);
        }
        if (parameter instanceof Circle) {
            return this.convertCircle((Circle)parameter);
        }
        if (parameter instanceof Instant) {
            return ((Instant)parameter).atOffset(ZoneOffset.UTC);
        }
        if (parameter instanceof Box) {
            return this.convertBox((Box)parameter);
        }
        if (parameter instanceof BoundingBox) {
            return this.convertBoundingBox((BoundingBox)parameter);
        }
        return this.mappingContext.getConversionService().writeValue(parameter, (TypeInformation<?>)ClassTypeInformation.from(parameter.getClass()), conversionOverride);
    }

    private Map<String, Object> convertRange(Range range) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        range.getLowerBound().getValue().map(this::convertParameter).ifPresent(v -> map.put("lb", v));
        range.getUpperBound().getValue().map(this::convertParameter).ifPresent(v -> map.put("ub", v));
        return map;
    }

    private Map<String, Object> convertCircle(Circle circle) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("x", this.convertParameter(circle.getCenter().getX()));
        map.put("y", this.convertParameter(circle.getCenter().getY()));
        map.put("radius", this.convertParameter(Neo4jQuerySupport.calculateDistanceInMeter(circle.getRadius())));
        return map;
    }

    private Map<String, Object> convertBox(Box box) {
        BoundingBox boundingBox = BoundingBox.of(box);
        return this.convertBoundingBox(boundingBox);
    }

    private Map<String, Object> convertBoundingBox(BoundingBox boundingBox) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("llx", this.convertParameter(boundingBox.getLowerLeft().getX()));
        map.put("lly", this.convertParameter(boundingBox.getLowerLeft().getY()));
        map.put("urx", this.convertParameter(boundingBox.getUpperRight().getX()));
        map.put("ury", this.convertParameter(boundingBox.getUpperRight().getY()));
        return map;
    }

    private static double calculateDistanceInMeter(Distance distance) {
        if (distance.getMetric() == Metrics.KILOMETERS) {
            double kilometersDivisor = 0.001;
            return distance.getValue() / kilometersDivisor;
        }
        if (distance.getMetric() == Metrics.MILES) {
            double milesDivisor = 6.2137E-4;
            return distance.getValue() / milesDivisor;
        }
        return distance.getValue();
    }
}

