/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.convert;

import org.springframework.beans.BeanUtils;
import org.springframework.data.neo4j.core.convert.ConvertWith;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverter;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverterFactory;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;

final class DefaultNeo4jPersistentPropertyConverterFactory
implements Neo4jPersistentPropertyConverterFactory {
    DefaultNeo4jPersistentPropertyConverterFactory() {
    }

    @Override
    public Neo4jPersistentPropertyConverter getPropertyConverterFor(Neo4jPersistentProperty persistentProperty) {
        ConvertWith config = (ConvertWith)persistentProperty.findAnnotation(ConvertWith.class);
        if (config.converter() == ConvertWith.UnsetConverter.class) {
            throw new IllegalArgumentException("The default custom conversion factory cannot be used with a placeholder");
        }
        Neo4jPersistentPropertyConverter converter = (Neo4jPersistentPropertyConverter)BeanUtils.instantiateClass(config.converter());
        return converter;
    }
}

