/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.Statement;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.core.ReactiveNeo4jOperations;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.repository.query.Predicate;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.data.repository.query.ReactiveQueryByExampleExecutor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@API(status=API.Status.INTERNAL, since="6.0")
public final class SimpleReactiveQueryByExampleExecutor<T>
implements ReactiveQueryByExampleExecutor<T> {
    private final ReactiveNeo4jOperations neo4jOperations;
    private final Neo4jMappingContext mappingContext;
    private final CypherGenerator cypherGenerator;

    public SimpleReactiveQueryByExampleExecutor(ReactiveNeo4jOperations neo4jOperations, Neo4jMappingContext mappingContext) {
        this.neo4jOperations = neo4jOperations;
        this.mappingContext = mappingContext;
        this.cypherGenerator = CypherGenerator.INSTANCE;
    }

    public <S extends T> Mono<S> findOne(Example<S> example) {
        return this.neo4jOperations.toExecutableQuery(example.getProbeType(), QueryFragmentsAndParameters.forExample(this.mappingContext, example)).flatMap(ReactiveNeo4jOperations.ExecutableQuery::getSingleResult);
    }

    public <S extends T> Flux<S> findAll(Example<S> example) {
        return this.neo4jOperations.toExecutableQuery(example.getProbeType(), QueryFragmentsAndParameters.forExample(this.mappingContext, example)).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    public <S extends T> Flux<S> findAll(Example<S> example, Sort sort) {
        return this.neo4jOperations.toExecutableQuery(example.getProbeType(), QueryFragmentsAndParameters.forExample(this.mappingContext, example, sort)).flatMapMany(ReactiveNeo4jOperations.ExecutableQuery::getResults);
    }

    public <S extends T> Mono<Long> count(Example<S> example) {
        Predicate predicate = Predicate.create(this.mappingContext, example);
        Statement statement = predicate.useWithReadingFragment(this.cypherGenerator::prepareMatchOf).returning(new Expression[]{Functions.count((Expression)Cypher.asterisk())}).build();
        return this.neo4jOperations.count(statement, predicate.getParameters());
    }

    public <S extends T> Mono<Boolean> exists(Example<S> example) {
        return this.findAll(example).hasElements();
    }
}

