/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.neo4j.core.mapping.DefaultNeo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.NodeDescriptionAndLabels;
import org.springframework.lang.Nullable;

final class NodeDescriptionStore {
    private final Map<String, NodeDescription<?>> nodeDescriptionsByPrimaryLabel = new HashMap();

    NodeDescriptionStore() {
    }

    public boolean containsKey(String primaryLabel) {
        return this.nodeDescriptionsByPrimaryLabel.containsKey(primaryLabel);
    }

    public <T> boolean containsValue(DefaultNeo4jPersistentEntity<T> newEntity) {
        return this.nodeDescriptionsByPrimaryLabel.containsValue(newEntity);
    }

    public <T> void put(String primaryLabel, DefaultNeo4jPersistentEntity<T> newEntity) {
        this.nodeDescriptionsByPrimaryLabel.put(primaryLabel, newEntity);
    }

    public Set<Map.Entry<String, NodeDescription<?>>> entrySet() {
        return this.nodeDescriptionsByPrimaryLabel.entrySet();
    }

    public Collection<NodeDescription<?>> values() {
        return this.nodeDescriptionsByPrimaryLabel.values();
    }

    @Nullable
    public NodeDescription<?> get(String primaryLabel) {
        return this.nodeDescriptionsByPrimaryLabel.get(primaryLabel);
    }

    @Nullable
    public NodeDescription<?> getNodeDescription(Class<?> targetType) {
        for (NodeDescription<?> nodeDescription : this.values()) {
            if (!nodeDescription.getUnderlyingClass().equals(targetType)) continue;
            return nodeDescription;
        }
        return null;
    }

    public static NodeDescriptionAndLabels deriveConcreteNodeDescription(Neo4jPersistentEntity<?> entityDescription, List<String> labels) {
        if (labels == null || labels.isEmpty()) {
            return new NodeDescriptionAndLabels(entityDescription, Collections.emptyList());
        }
        for (NodeDescription childNodeDescription : entityDescription.getChildNodeDescriptionsInHierarchy()) {
            String primaryLabel = childNodeDescription.getPrimaryLabel();
            ArrayList<String> additionalLabels = new ArrayList<String>(childNodeDescription.getAdditionalLabels());
            additionalLabels.add(primaryLabel);
            if (!additionalLabels.containsAll(labels) || !childNodeDescription.getChildNodeDescriptionsInHierarchy().isEmpty()) continue;
            HashSet<String> surplusLabels = new HashSet<String>(labels);
            surplusLabels.remove(primaryLabel);
            surplusLabels.removeAll(additionalLabels);
            return new NodeDescriptionAndLabels(childNodeDescription, surplusLabels);
        }
        HashSet<String> surplusLabels = new HashSet<String>(labels);
        surplusLabels.remove(entityDescription.getPrimaryLabel());
        surplusLabels.removeAll(entityDescription.getAdditionalLabels());
        return new NodeDescriptionAndLabels(entityDescription, surplusLabels);
    }
}

