/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.support;

import java.util.Map;
import java.util.function.Function;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.ChainedPersistenceExceptionTranslator;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ReactivePersistenceExceptionTranslationInterceptor
implements MethodInterceptor {
    private final ListableBeanFactory beanFactory;
    private volatile PersistenceExceptionTranslator persistenceExceptionTranslator;

    ReactivePersistenceExceptionTranslationInterceptor(ListableBeanFactory beanFactory) {
        Assert.notNull((Object)beanFactory, (String)"ListableBeanFactory must not be null");
        this.beanFactory = beanFactory;
    }

    public Object invoke(MethodInvocation mi) throws Throwable {
        Object m = mi.proceed();
        PersistenceExceptionTranslator translator = this.getPersistenceExceptionTranslator();
        if (translator == null) {
            return m;
        }
        Function<RuntimeException, Throwable> errorMappingFunction = t -> t instanceof DataAccessException ? t : DataAccessUtils.translateIfNecessary((RuntimeException)t, (PersistenceExceptionTranslator)translator);
        if (m instanceof Mono) {
            return ((Mono)m).onErrorMap(RuntimeException.class, errorMappingFunction);
        }
        if (m instanceof Flux) {
            return ((Flux)m).onErrorMap(RuntimeException.class, errorMappingFunction);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PersistenceExceptionTranslator getPersistenceExceptionTranslator() {
        PersistenceExceptionTranslator translator = this.persistenceExceptionTranslator;
        if (translator == null) {
            ReactivePersistenceExceptionTranslationInterceptor reactivePersistenceExceptionTranslationInterceptor = this;
            synchronized (reactivePersistenceExceptionTranslationInterceptor) {
                translator = this.persistenceExceptionTranslator;
                if (translator == null) {
                    translator = this.persistenceExceptionTranslator = this.detectPersistenceExceptionTranslators();
                }
            }
        }
        return translator;
    }

    private PersistenceExceptionTranslator detectPersistenceExceptionTranslators() {
        Map pets = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, PersistenceExceptionTranslator.class, (boolean)false, (boolean)false);
        ChainedPersistenceExceptionTranslator cpet = new ChainedPersistenceExceptionTranslator();
        pets.values().forEach(arg_0 -> ((ChainedPersistenceExceptionTranslator)cpet).addDelegate(arg_0));
        return cpet;
    }
}

