/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.LongSupplier;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Conditions;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.Statement;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.core.Neo4jOperations;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.repository.query.CypherAdapterUtils;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.data.neo4j.repository.support.CypherdslConditionExecutor;
import org.springframework.data.neo4j.repository.support.Neo4jEntityInformation;
import org.springframework.data.support.PageableExecutionUtils;

@API(status=API.Status.INTERNAL, since="6.1")
public final class CypherdslConditionExecutorImpl<T>
implements CypherdslConditionExecutor<T> {
    private final Neo4jEntityInformation<T, Object> entityInformation;
    private final Neo4jOperations neo4jOperations;
    private final Neo4jPersistentEntity<T> metaData;

    public CypherdslConditionExecutorImpl(Neo4jEntityInformation<T, Object> entityInformation, Neo4jOperations neo4jOperations) {
        this.entityInformation = entityInformation;
        this.neo4jOperations = neo4jOperations;
        this.metaData = this.entityInformation.getEntityMetaData();
    }

    @Override
    public Optional<T> findOne(Condition condition) {
        return this.neo4jOperations.toExecutableQuery(this.metaData.getType(), QueryFragmentsAndParameters.forCondition(this.metaData, condition, null, null)).getSingleResult();
    }

    @Override
    public Collection<T> findAll(Condition condition) {
        return this.neo4jOperations.toExecutableQuery(this.metaData.getType(), QueryFragmentsAndParameters.forCondition(this.metaData, condition, null, null)).getResults();
    }

    @Override
    public Collection<T> findAll(Condition condition, Sort sort) {
        return this.neo4jOperations.toExecutableQuery(this.metaData.getType(), QueryFragmentsAndParameters.forCondition(this.metaData, condition, null, CypherAdapterUtils.toSortItems(this.metaData, sort))).getResults();
    }

    @Override
    public Collection<T> findAll(Condition condition, SortItem ... sortItems) {
        return this.neo4jOperations.toExecutableQuery(this.metaData.getType(), QueryFragmentsAndParameters.forCondition(this.metaData, condition, null, sortItems)).getResults();
    }

    @Override
    public Collection<T> findAll(SortItem ... sortItems) {
        return this.neo4jOperations.toExecutableQuery(this.metaData.getType(), QueryFragmentsAndParameters.forCondition(this.metaData, Conditions.noCondition(), null, sortItems)).getResults();
    }

    @Override
    public Page<T> findAll(Condition condition, Pageable pageable) {
        List page = this.neo4jOperations.toExecutableQuery(this.metaData.getType(), QueryFragmentsAndParameters.forCondition(this.metaData, condition, pageable, null)).getResults();
        LongSupplier totalCountSupplier = () -> this.count(condition);
        return PageableExecutionUtils.getPage(page, (Pageable)pageable, (LongSupplier)totalCountSupplier);
    }

    @Override
    public long count(Condition condition) {
        Statement statement = CypherGenerator.INSTANCE.prepareMatchOf(this.metaData, condition).returning(new Expression[]{Functions.count((Expression)Cypher.asterisk())}).build();
        return this.neo4jOperations.count(statement, (Map<String, Object>)statement.getParameters());
    }

    @Override
    public boolean exists(Condition condition) {
        return this.findAll(condition).iterator().hasNext();
    }
}

