/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.lang.reflect.Method;
import org.apiguardian.api.API;
import org.springframework.data.neo4j.core.ReactiveNeo4jOperations;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.repository.query.ReactiveCypherdslBasedQuery;
import org.springframework.data.neo4j.repository.query.ReactiveNeo4jQueryMethod;
import org.springframework.data.neo4j.repository.query.ReactivePartTreeNeo4jQuery;
import org.springframework.data.neo4j.repository.query.ReactiveStringBasedNeo4jQuery;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;

@API(status=API.Status.INTERNAL, since="6.0")
public final class ReactiveNeo4jQueryLookupStrategy
implements QueryLookupStrategy {
    private final ReactiveNeo4jOperations neo4jOperations;
    private final Neo4jMappingContext mappingContext;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;

    public ReactiveNeo4jQueryLookupStrategy(ReactiveNeo4jOperations neo4jOperations, Neo4jMappingContext mappingContext, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        this.neo4jOperations = neo4jOperations;
        this.mappingContext = mappingContext;
        this.evaluationContextProvider = evaluationContextProvider;
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
        ReactiveNeo4jQueryMethod queryMethod = new ReactiveNeo4jQueryMethod(method, metadata, factory);
        String namedQueryName = queryMethod.getNamedQueryName();
        if (namedQueries.hasQuery(namedQueryName)) {
            return ReactiveStringBasedNeo4jQuery.create(this.neo4jOperations, this.mappingContext, this.evaluationContextProvider, queryMethod, namedQueries.getQuery(namedQueryName));
        }
        if (queryMethod.hasQueryAnnotation()) {
            return ReactiveStringBasedNeo4jQuery.create(this.neo4jOperations, this.mappingContext, this.evaluationContextProvider, queryMethod);
        }
        if (queryMethod.isCypherBasedProjection()) {
            return ReactiveCypherdslBasedQuery.create(this.neo4jOperations, this.mappingContext, queryMethod);
        }
        return ReactivePartTreeNeo4jQuery.create(this.neo4jOperations, this.mappingContext, queryMethod);
    }
}

