/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Map;
import java.util.function.BiFunction;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.neo4j.core.PreparedQuery;
import org.springframework.data.neo4j.core.ReactiveNeo4jOperations;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.repository.query.AbstractReactiveNeo4jQuery;
import org.springframework.data.neo4j.repository.query.Neo4jParameterAccessor;
import org.springframework.data.neo4j.repository.query.Neo4jQueryMethod;
import org.springframework.data.neo4j.repository.query.Neo4jQueryType;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.util.Assert;

final class ReactiveCypherdslBasedQuery
extends AbstractReactiveNeo4jQuery {
    static ReactiveCypherdslBasedQuery create(ReactiveNeo4jOperations neo4jOperations, Neo4jMappingContext mappingContext, Neo4jQueryMethod queryMethod, ProjectionFactory projectionFactory) {
        return new ReactiveCypherdslBasedQuery(neo4jOperations, mappingContext, queryMethod, Neo4jQueryType.DEFAULT, projectionFactory);
    }

    private ReactiveCypherdslBasedQuery(ReactiveNeo4jOperations neo4jOperations, Neo4jMappingContext mappingContext, Neo4jQueryMethod queryMethod, Neo4jQueryType queryType, ProjectionFactory projectionFactory) {
        super(neo4jOperations, mappingContext, queryMethod, queryType, projectionFactory);
    }

    @Override
    protected <T> PreparedQuery<T> prepareQuery(Class<T> returnedType, Map<PropertyPath, Boolean> includedProperties, Neo4jParameterAccessor parameterAccessor, Neo4jQueryType queryType, BiFunction<TypeSystem, MapAccessor, ?> mappingFunction) {
        Object[] parameters = parameterAccessor.getValues();
        Assert.notEmpty((Object[])parameters, (String)"Cypher based query methods must provide at least a statement parameter.");
        Assert.isInstanceOf(Statement.class, (Object)parameters[0], (String)"The first parameter to a Cypher based method must be a statement.");
        Statement statement = (Statement)parameters[0];
        Map boundParameters = statement.getParameters();
        return PreparedQuery.queryFor(returnedType).withCypherQuery(statement.getCypher()).withParameters(boundParameters).usingMappingFunction(mappingFunction).build();
    }
}

