/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import org.apiguardian.api.API;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.MutablePersistentEntity;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@API(status=API.Status.INTERNAL, since="6.1.2")
public final class EntityFromDtoInstantiatingConverter<T>
implements Converter<Object, T> {
    private final Class<?> targetEntityType;
    private final Neo4jMappingContext context;

    public EntityFromDtoInstantiatingConverter(Class<T> entityType, Neo4jMappingContext context) {
        Assert.notNull(entityType, (String)"Entity type must not be null!");
        Assert.notNull((Object)context, (String)"MappingContext must not be null!");
        this.targetEntityType = entityType;
        this.context = context;
    }

    public T convert(Object dtoInstance) {
        if (dtoInstance == null) {
            return null;
        }
        PersistentEntity sourceEntity = (PersistentEntity)this.context.addPersistentEntity((TypeInformation<?>)ClassTypeInformation.from(dtoInstance.getClass())).get();
        PersistentPropertyAccessor sourceAccessor = sourceEntity.getPropertyAccessor(dtoInstance);
        MutablePersistentEntity targetEntity = this.context.getPersistentEntity(this.targetEntityType);
        PreferredConstructor constructor = targetEntity.getPersistenceConstructor();
        Object entity = this.context.getInstantiatorFor((PersistentEntity<?, ?>)targetEntity).createInstance((PersistentEntity)targetEntity, new ParameterValueProvider((PersistentEntity)targetEntity, sourceEntity, sourceAccessor){
            final /* synthetic */ PersistentEntity val$targetEntity;
            final /* synthetic */ PersistentEntity val$sourceEntity;
            final /* synthetic */ PersistentPropertyAccessor val$sourceAccessor;
            {
                this.val$targetEntity = persistentEntity;
                this.val$sourceEntity = persistentEntity2;
                this.val$sourceAccessor = persistentPropertyAccessor;
            }

            public Object getParameterValue(PreferredConstructor.Parameter parameter) {
                PersistentProperty targetProperty = this.val$targetEntity.getPersistentProperty(parameter.getName());
                if (targetProperty == null) {
                    throw new MappingException("Cannot map constructor parameter " + parameter.getName() + " to a property of class " + EntityFromDtoInstantiatingConverter.this.targetEntityType);
                }
                return EntityFromDtoInstantiatingConverter.this.getPropertyValueFor(targetProperty, this.val$sourceEntity, this.val$sourceAccessor);
            }
        });
        PersistentPropertyAccessor dtoAccessor = targetEntity.getPropertyAccessor(entity);
        targetEntity.doWithProperties(property -> {
            if (constructor.isConstructorParameter(property)) {
                return;
            }
            Object propertyValue = this.getPropertyValueFor(property, sourceEntity, sourceAccessor);
            dtoAccessor.setProperty(property, propertyValue);
        });
        return (T)entity;
    }

    @Nullable
    Object getPropertyValueFor(PersistentProperty<?> targetProperty, PersistentEntity<?, ?> sourceEntity, PersistentPropertyAccessor<?> sourceAccessor) {
        String targetPropertyName = targetProperty.getName();
        Class targetPropertyType = targetProperty.getType();
        PersistentProperty sourceProperty = sourceEntity.getPersistentProperty(targetPropertyName);
        Object propertyValue = null;
        if (sourceProperty != null) {
            propertyValue = sourceAccessor.getProperty(sourceProperty);
        }
        if (propertyValue == null && targetPropertyType.isPrimitive()) {
            return ReflectionUtils.getPrimitiveDefault((Class)targetPropertyType);
        }
        return propertyValue;
    }
}

