/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.config;

import java.util.Optional;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogAccessor;
import org.springframework.data.neo4j.core.support.UserAgent;

final class StartupLogger {
    private static final LogAccessor logger = new LogAccessor(LogFactory.getLog(StartupLogger.class));
    private final Mode mode;

    StartupLogger(Mode mode) {
        this.mode = mode;
    }

    void logStarting() {
        if (!logger.isDebugEnabled()) {
            return;
        }
        logger.debug(this::getStartingMessage);
    }

    String getStartingMessage() {
        StringBuilder sb = new StringBuilder();
        UserAgent userAgent = UserAgent.INSTANCE;
        String sdnRx = Optional.ofNullable(userAgent.getSdnVersion()).map(v -> "SDN v" + v).orElse("an unknown version of SDN");
        String sdC = Optional.ofNullable(userAgent.getSpringDataVersion()).map(v -> "Spring Data Commons v" + v).orElse("an unknown version of Spring Data Commons");
        String driver = Optional.ofNullable(userAgent.getDriverVersion()).map(v -> "Neo4j Driver v" + v).orElse("an unknown version of the Neo4j Java Driver");
        sb.append("Bootstrapping ").append(this.mode.displayValue).append(" Neo4j repositories based on ").append(sdnRx).append(" with ").append(sdC).append(" and ").append(driver).append(".");
        return sb.toString();
    }

    static enum Mode {
        IMPERATIVE("imperative"),
        REACTIVE("reactive");

        final String displayValue;

        private Mode(String displayValue) {
            this.displayValue = displayValue;
        }
    }
}

