/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.transaction;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.neo4j.driver.Bookmark;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.neo4j.core.transaction.AbstractBookmarkManager;
import org.springframework.data.neo4j.core.transaction.Neo4jBookmarksUpdatedEvent;
import org.springframework.lang.Nullable;

final class ReactiveDefaultBookmarkManager
extends AbstractBookmarkManager {
    private final Set<Bookmark> bookmarks = new HashSet<Bookmark>();
    private final Supplier<Set<Bookmark>> bookmarksSupplier;
    @Nullable
    private ApplicationEventPublisher applicationEventPublisher;

    ReactiveDefaultBookmarkManager(@Nullable Supplier<Set<Bookmark>> bookmarksSupplier) {
        this.bookmarksSupplier = bookmarksSupplier == null ? Collections::emptySet : bookmarksSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Bookmark> getBookmarks() {
        Set<Bookmark> set = this.bookmarks;
        synchronized (set) {
            this.bookmarks.addAll((Collection<Bookmark>)this.bookmarksSupplier.get());
            return Set.copyOf(this.bookmarks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBookmarks(Collection<Bookmark> usedBookmarks, Collection<Bookmark> newBookmarks) {
        Set<Bookmark> set = this.bookmarks;
        synchronized (set) {
            usedBookmarks.stream().filter(Objects::nonNull).forEach(this.bookmarks::remove);
            newBookmarks.stream().filter(Objects::nonNull).forEach(this.bookmarks::add);
            if (this.applicationEventPublisher != null) {
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new Neo4jBookmarksUpdatedEvent(new HashSet<Bookmark>(this.bookmarks)));
            }
        }
    }

    @Override
    public void setApplicationEventPublisher(@Nullable ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }
}

