/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.neo4j.core.convert.AdditionalTypes;
import org.springframework.data.neo4j.core.convert.CypherTypes;
import org.springframework.data.neo4j.core.convert.Neo4jSimpleTypes;
import org.springframework.data.neo4j.core.convert.SpatialTypes;

@API(status=API.Status.STABLE, since="6.0")
public final class Neo4jConversions
extends CustomConversions {
    private static final CustomConversions.StoreConversions STORE_CONVERSIONS;
    private static final List<Object> STORE_CONVERTERS;

    public Neo4jConversions() {
        this(Collections.emptyList());
    }

    public Neo4jConversions(Collection<?> converters) {
        super(STORE_CONVERSIONS, converters);
    }

    public void registerConvertersIn(ConverterRegistry conversionService) {
        super.registerConvertersIn(conversionService);
        conversionService.addConverter((GenericConverter)new AdditionalTypes.EnumArrayConverter());
    }

    static {
        ArrayList converters = new ArrayList();
        converters.addAll(CypherTypes.CONVERTERS);
        converters.addAll(AdditionalTypes.CONVERTERS);
        converters.addAll(SpatialTypes.CONVERTERS);
        STORE_CONVERTERS = Collections.unmodifiableList(converters);
        STORE_CONVERSIONS = CustomConversions.StoreConversions.of((SimpleTypeHolder)Neo4jSimpleTypes.HOLDER, STORE_CONVERTERS);
    }
}

