/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.util.Objects;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.RelationshipDescription;
import org.springframework.data.neo4j.core.schema.Relationship;
import org.springframework.lang.Nullable;

final class DefaultRelationshipDescription
extends Association<Neo4jPersistentProperty>
implements RelationshipDescription {
    private final String type;
    private final boolean dynamic;
    private final NodeDescription<?> source;
    private final NodeDescription<?> target;
    private final String fieldName;
    private final Relationship.Direction direction;
    private final NodeDescription<?> relationshipPropertiesClass;
    private RelationshipDescription relationshipObverse;
    private final boolean cascadeUpdates;

    DefaultRelationshipDescription(Neo4jPersistentProperty inverse, @Nullable RelationshipDescription relationshipObverse, String type, boolean dynamic, NodeDescription<?> source, String fieldName, NodeDescription<?> target, Relationship.Direction direction, @Nullable NodeDescription<?> relationshipProperties, boolean cascadeUpdates) {
        super((PersistentProperty)inverse, null);
        this.relationshipObverse = relationshipObverse;
        this.type = type;
        this.dynamic = dynamic;
        this.source = source;
        this.fieldName = fieldName;
        this.target = target;
        this.direction = direction;
        this.relationshipPropertiesClass = relationshipProperties;
        this.cascadeUpdates = cascadeUpdates;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    public NodeDescription<?> getTarget() {
        return this.target;
    }

    @Override
    public NodeDescription<?> getSource() {
        return this.source;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public Relationship.Direction getDirection() {
        return this.direction;
    }

    @Override
    public NodeDescription<?> getRelationshipPropertiesEntity() {
        return this.relationshipPropertiesClass;
    }

    @Override
    public boolean hasRelationshipProperties() {
        return this.getRelationshipPropertiesEntity() != null;
    }

    @Override
    public void setRelationshipObverse(RelationshipDescription relationshipObverse) {
        this.relationshipObverse = relationshipObverse;
    }

    @Override
    public RelationshipDescription getRelationshipObverse() {
        return this.relationshipObverse;
    }

    @Override
    public boolean hasRelationshipObverse() {
        return this.relationshipObverse != null;
    }

    @Override
    public boolean cascadeUpdates() {
        return this.cascadeUpdates;
    }

    public String toString() {
        return "DefaultRelationshipDescription{type='" + this.type + "', source='" + this.source + "', direction='" + this.direction + "', target='" + this.target + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultRelationshipDescription)) {
            return false;
        }
        DefaultRelationshipDescription that = (DefaultRelationshipDescription)o;
        return (this.isDynamic() ? this.getFieldName().equals(that.getFieldName()) : this.getType().equals(that.getType())) && this.getTarget().equals(that.getTarget()) && this.getSource().equals(that.getSource()) && this.getDirection().equals((Object)that.getDirection());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fieldName, this.type, this.target, this.source, this.direction});
    }
}

