/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.support;

import org.neo4j.driver.Driver;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.neo4j.repository.config.EnableNeo4jRepositories;
import org.springframework.lang.Nullable;

public enum UserAgent {
    INSTANCE(UserAgent.getVersionOf(Driver.class), UserAgent.getVersionOf(AbstractMappingContext.class), UserAgent.getVersionOf(EnableNeo4jRepositories.class));

    @Nullable
    private final String driverVersion;
    @Nullable
    private final String springDataVersion;
    @Nullable
    private final String sdnVersion;
    private final String representation;

    private UserAgent(@Nullable String driverVersion, String springDataVersion, String sdnVersion) {
        int idxOfDash;
        int n2 = idxOfDash = driverVersion == null ? -1 : driverVersion.indexOf(45);
        this.driverVersion = driverVersion == null ? null : driverVersion.substring(0, idxOfDash > 0 ? idxOfDash : driverVersion.length());
        this.springDataVersion = springDataVersion;
        this.sdnVersion = sdnVersion;
        String unknown = "-";
        this.representation = String.format("Java/%s (%s %s %s) neo4j-java/%s spring-data/%s spring-data-neo4j/%s", System.getProperty("java.version"), System.getProperty("java.vm.vendor"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), this.driverVersion == null ? unknown : this.driverVersion, this.springDataVersion == null ? unknown : this.springDataVersion, this.sdnVersion == null ? unknown : this.sdnVersion);
    }

    @Nullable
    public String getDriverVersion() {
        return this.driverVersion;
    }

    @Nullable
    public String getSpringDataVersion() {
        return this.springDataVersion;
    }

    @Nullable
    public String getSdnVersion() {
        return this.sdnVersion;
    }

    @Nullable
    private static String getVersionOf(Class<?> type) {
        Package p = type.getPackage();
        String version = p.getImplementationVersion();
        if (version != null && !version.trim().isEmpty()) {
            return version;
        }
        return null;
    }

    public String toString() {
        return this.representation;
    }
}

