/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.transaction;

import org.neo4j.driver.Driver;
import org.reactivestreams.Publisher;
import org.springframework.data.neo4j.core.transaction.ReactiveNeo4jTransactionHolder;
import org.springframework.transaction.reactive.ReactiveResourceSynchronization;
import org.springframework.transaction.reactive.TransactionSynchronizationManager;
import reactor.core.publisher.Mono;

final class ReactiveNeo4jSessionSynchronization
extends ReactiveResourceSynchronization<ReactiveNeo4jTransactionHolder, Object> {
    private final ReactiveNeo4jTransactionHolder transactionHolder;

    ReactiveNeo4jSessionSynchronization(TransactionSynchronizationManager transactionSynchronizationManager, ReactiveNeo4jTransactionHolder transactionHolder, Driver driver) {
        super((Object)transactionHolder, (Object)driver, transactionSynchronizationManager);
        this.transactionHolder = transactionHolder;
    }

    protected boolean shouldReleaseBeforeCompletion() {
        return false;
    }

    protected Mono<Void> processResourceAfterCommit(ReactiveNeo4jTransactionHolder resourceHolder) {
        return Mono.defer(() -> super.processResourceAfterCommit((Object)resourceHolder).then(resourceHolder.commit())).then();
    }

    public Mono<Void> afterCompletion(int status) {
        return Mono.defer(() -> {
            if (status == 1) {
                return this.transactionHolder.rollback().then(super.afterCompletion(status));
            }
            return super.afterCompletion(status);
        });
    }

    protected Mono<Void> releaseResource(ReactiveNeo4jTransactionHolder resourceHolder, Object resourceKey) {
        return Mono.defer(() -> Mono.fromDirect((Publisher)resourceHolder.getSession().close()).then());
    }
}

