/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Arrays;
import java.util.Objects;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;

public final class BoundingBox {
    private final Point lowerLeft;
    private final Point upperRight;

    public static BoundingBox of(Polygon p) {
        return BoundingBox.buildFrom(p.getPoints());
    }

    public static BoundingBox of(Box b) {
        return BoundingBox.buildFrom(Arrays.asList(b.getFirst(), b.getSecond()));
    }

    private static BoundingBox buildFrom(Iterable<Point> points) {
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (Point point : points) {
            minX = Math.min(point.getX(), minX);
            minY = Math.min(point.getY(), minY);
            maxX = Math.max(point.getX(), maxX);
            maxY = Math.max(point.getY(), maxY);
        }
        return new BoundingBox(new Point(minX, minY), new Point(maxX, maxY));
    }

    private BoundingBox(Point lowerLeft, Point upperRight) {
        this.lowerLeft = lowerLeft;
        this.upperRight = upperRight;
    }

    public Point getLowerLeft() {
        return this.lowerLeft;
    }

    public Point getUpperRight() {
        return this.upperRight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundingBox that = (BoundingBox)o;
        return this.lowerLeft.equals((Object)that.lowerLeft) && this.upperRight.equals((Object)that.upperRight);
    }

    public int hashCode() {
        return Objects.hash(this.lowerLeft, this.upperRight);
    }

    public String toString() {
        return "BoundingBox{ll=" + this.lowerLeft + ", ur=" + this.upperRight + "}";
    }
}

