/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.config.oracle;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class AqJmsConnectionFactoryBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private static final String FACTORY_BEAN_CLASS = "org.springframework.data.jdbc.config.oracle.AqJmsFactoryBeanFactory";
    private static final String DATA_SOURCE_ATTRIBUTE = "data-source";
    private static final String USE_LOCAL_DATA_SOURCE_TX_ATTRIBUTE = "use-local-data-source-transaction";
    private static final String CONNECTION_FACTORY_TYPE_ATTRIBUTE = "connection-factory-type";
    private static final String NATIVE_JDBC_EXTRACTOR_ATTRIBUTE = "native-jdbc-extractor";
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());

    protected String getBeanClassName(Element element) {
        return FACTORY_BEAN_CLASS;
    }

    protected boolean shouldGenerateId() {
        return false;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String dataSourceRef = element.getAttribute(DATA_SOURCE_ATTRIBUTE);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Using provided native-jdbc-extractor: " + dataSourceRef));
        }
        String useLocalDataSourceTx = element.getAttribute(USE_LOCAL_DATA_SOURCE_TX_ATTRIBUTE);
        String connectionFactoryTypeRef = element.getAttribute(CONNECTION_FACTORY_TYPE_ATTRIBUTE);
        String nativeJdbcExtractorRef = element.getAttribute(NATIVE_JDBC_EXTRACTOR_ATTRIBUTE);
        builder.getRawBeanDefinition().setBeanClassName(FACTORY_BEAN_CLASS);
        RuntimeBeanReference ds = new RuntimeBeanReference(dataSourceRef);
        builder.addPropertyValue("dataSource", (Object)ds);
        if (StringUtils.hasText((String)useLocalDataSourceTx)) {
            if ("true".equals(useLocalDataSourceTx.toLowerCase()) || "false".equals(useLocalDataSourceTx.toLowerCase())) {
                builder.addPropertyValue("coordinateWithDataSourceTransactions", (Object)useLocalDataSourceTx);
            } else {
                parserContext.getReaderContext().error("The 'use-local-data-source-transaction' attribute should be \"true\" or \"false\"; \"" + useLocalDataSourceTx + "\" is an invalid value", (Object)element);
            }
        }
        if (StringUtils.hasText((String)connectionFactoryTypeRef)) {
            builder.addPropertyValue("connectionFactoryType", (Object)connectionFactoryTypeRef);
        }
        if (StringUtils.hasText((String)nativeJdbcExtractorRef)) {
            RuntimeBeanReference nje = new RuntimeBeanReference(nativeJdbcExtractorRef);
            builder.addPropertyValue("nativeJdbcExtractor", (Object)nje);
        }
        builder.setRole(1);
    }

    protected void registerBeanDefinition(BeanDefinitionHolder beanDefinitionHolder, BeanDefinitionRegistry beanDefinitionRegistry) {
        super.registerBeanDefinition(beanDefinitionHolder, beanDefinitionRegistry);
    }
}

