/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.support.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.jdbc.core.support.AbstractSqlTypeValue;

public class SqlArrayValue<T>
extends AbstractSqlTypeValue {
    private T[] values;
    private String defaultTypeName;

    public SqlArrayValue(T[] values) {
        this.values = values;
    }

    public SqlArrayValue(T[] values, String defaultTypeName) {
        this.values = values;
        this.defaultTypeName = defaultTypeName;
    }

    protected Object createTypeValue(Connection conn, int sqlType, String typeName) throws SQLException {
        if (typeName == null && this.defaultTypeName == null) {
            throw new InvalidDataAccessApiUsageException("The typeName is null in this context. Consider setting the defaultTypeName.");
        }
        ArrayDescriptor arrayDescriptor = new ArrayDescriptor(typeName != null ? typeName : this.defaultTypeName, conn);
        ARRAY array = new ARRAY(arrayDescriptor, conn, this.values);
        return array;
    }
}

