/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.core;

import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.r2dbc.core.DefaultDatabaseClientBuilder;
import org.springframework.data.r2dbc.core.FetchSpec;
import org.springframework.data.r2dbc.core.ReactiveDataAccessStrategy;
import org.springframework.data.r2dbc.core.RowsFetchSpec;
import org.springframework.data.r2dbc.core.UpdatedRowsFetchSpec;
import org.springframework.data.r2dbc.mapping.SettableValue;
import org.springframework.data.r2dbc.query.Criteria;
import org.springframework.data.r2dbc.query.Update;
import org.springframework.data.r2dbc.support.R2dbcExceptionTranslator;
import reactor.core.publisher.Mono;

public interface DatabaseClient {
    public GenericExecuteSpec execute(String var1);

    public GenericExecuteSpec execute(Supplier<String> var1);

    public SelectFromSpec select();

    public InsertIntoSpec insert();

    public UpdateTableSpec update();

    public DeleteFromSpec delete();

    public Builder mutate();

    public static DatabaseClient create(ConnectionFactory factory) {
        return new DefaultDatabaseClientBuilder().connectionFactory(factory).build();
    }

    public static Builder builder() {
        return new DefaultDatabaseClientBuilder();
    }

    public static interface BindSpec<S extends BindSpec<S>> {
        public S bind(int var1, Object var2);

        public S bindNull(int var1, Class<?> var2);

        public S bind(String var1, Object var2);

        public S bindNull(String var1, Class<?> var2);
    }

    public static interface DeleteSpec {
        public UpdatedRowsFetchSpec fetch();

        public Mono<Void> then();
    }

    public static interface DeleteMatchingSpec
    extends DeleteSpec {
        public DeleteSpec matching(Criteria var1);
    }

    public static interface TypedDeleteSpec<T>
    extends DeleteSpec {
        public TypedDeleteSpec<T> table(String var1);

        public DeleteSpec matching(Criteria var1);
    }

    public static interface UpdateSpec {
        public UpdatedRowsFetchSpec fetch();

        public Mono<Void> then();
    }

    public static interface UpdateMatchingSpec
    extends UpdateSpec {
        public UpdateSpec matching(Criteria var1);
    }

    public static interface TypedUpdateSpec<T> {
        public UpdateSpec using(T var1);

        public TypedUpdateSpec<T> table(String var1);
    }

    public static interface GenericUpdateSpec {
        public UpdateMatchingSpec using(Update var1);
    }

    public static interface InsertSpec<T> {
        public <R> RowsFetchSpec<R> map(Function<Row, R> var1);

        public <R> RowsFetchSpec<R> map(BiFunction<Row, RowMetadata, R> var1);

        public FetchSpec<T> fetch();

        public Mono<Void> then();
    }

    public static interface TypedInsertSpec<T> {
        public InsertSpec<Map<String, Object>> using(T var1);

        public TypedInsertSpec<T> table(String var1);

        public InsertSpec<Map<String, Object>> using(Publisher<T> var1);
    }

    public static interface GenericInsertSpec<T>
    extends InsertSpec<T> {
        public GenericInsertSpec<T> value(String var1, Object var2);

        default public GenericInsertSpec<T> nullValue(String field, Class<?> type) {
            return this.value(field, SettableValue.empty(type));
        }
    }

    public static interface SelectSpec<S extends SelectSpec<S>> {
        public S project(String ... var1);

        public S matching(Criteria var1);

        public S orderBy(Sort var1);

        default public S orderBy(Sort.Order ... orders) {
            return this.orderBy(Sort.by((Sort.Order[])orders));
        }

        public S page(Pageable var1);
    }

    public static interface TypedSelectSpec<T>
    extends SelectSpec<TypedSelectSpec<T>> {
        public <R> RowsFetchSpec<R> as(Class<R> var1);

        public <R> RowsFetchSpec<R> map(Function<Row, R> var1);

        public <R> RowsFetchSpec<R> map(BiFunction<Row, RowMetadata, R> var1);

        public FetchSpec<T> fetch();
    }

    public static interface GenericSelectSpec
    extends SelectSpec<GenericSelectSpec> {
        public <R> TypedSelectSpec<R> as(Class<R> var1);

        public <R> RowsFetchSpec<R> map(Function<Row, R> var1);

        public <R> RowsFetchSpec<R> map(BiFunction<Row, RowMetadata, R> var1);

        public FetchSpec<Map<String, Object>> fetch();
    }

    public static interface DeleteFromSpec {
        public DeleteMatchingSpec from(String var1);

        public <T> TypedDeleteSpec<T> from(Class<T> var1);
    }

    public static interface UpdateTableSpec {
        public GenericUpdateSpec table(String var1);

        public <T> TypedUpdateSpec<T> table(Class<T> var1);
    }

    public static interface InsertIntoSpec {
        public GenericInsertSpec<Map<String, Object>> into(String var1);

        public <T> TypedInsertSpec<T> into(Class<T> var1);
    }

    public static interface SelectFromSpec {
        public GenericSelectSpec from(String var1);

        public <T> TypedSelectSpec<T> from(Class<T> var1);
    }

    public static interface TypedExecuteSpec<T>
    extends BindSpec<TypedExecuteSpec<T>> {
        public <R> TypedExecuteSpec<R> as(Class<R> var1);

        public <R> RowsFetchSpec<R> map(Function<Row, R> var1);

        public <R> RowsFetchSpec<R> map(BiFunction<Row, RowMetadata, R> var1);

        public FetchSpec<T> fetch();

        public Mono<Void> then();
    }

    public static interface GenericExecuteSpec
    extends BindSpec<GenericExecuteSpec> {
        public <R> TypedExecuteSpec<R> as(Class<R> var1);

        public <R> RowsFetchSpec<R> map(Function<Row, R> var1);

        public <R> RowsFetchSpec<R> map(BiFunction<Row, RowMetadata, R> var1);

        public FetchSpec<Map<String, Object>> fetch();

        public Mono<Void> then();
    }

    public static interface Builder {
        public Builder connectionFactory(ConnectionFactory var1);

        public Builder exceptionTranslator(R2dbcExceptionTranslator var1);

        public Builder dataAccessStrategy(ReactiveDataAccessStrategy var1);

        public Builder namedParameters(boolean var1);

        public Builder apply(Consumer<Builder> var1);

        public DatabaseClient build();
    }
}

