/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.mapping;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.springframework.data.r2dbc.mapping.SettableValue;
import org.springframework.util.Assert;

public class OutboundRow
implements Map<String, SettableValue> {
    private final Map<String, SettableValue> rowAsMap;

    public OutboundRow() {
        this.rowAsMap = new LinkedHashMap<String, SettableValue>();
    }

    public OutboundRow(Map<String, SettableValue> map) {
        Assert.notNull(map, (String)"Map must not be null");
        this.rowAsMap = new LinkedHashMap<String, SettableValue>(map);
    }

    public OutboundRow(String key, SettableValue value) {
        this.rowAsMap = new LinkedHashMap<String, SettableValue>();
        this.rowAsMap.put(key, value);
    }

    public OutboundRow append(String key, SettableValue value) {
        this.rowAsMap.put(key, value);
        return this;
    }

    @Override
    public int size() {
        return this.rowAsMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rowAsMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.rowAsMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.rowAsMap.containsValue(value);
    }

    @Override
    public SettableValue get(Object key) {
        return this.rowAsMap.get(key);
    }

    @Override
    public SettableValue put(String key, SettableValue value) {
        return this.rowAsMap.put(key, value);
    }

    @Override
    public SettableValue remove(Object key) {
        return this.rowAsMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends SettableValue> m) {
        this.rowAsMap.putAll(m);
    }

    @Override
    public void clear() {
        this.rowAsMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.rowAsMap.keySet();
    }

    @Override
    public Collection<SettableValue> values() {
        return this.rowAsMap.values();
    }

    @Override
    public Set<Map.Entry<String, SettableValue>> entrySet() {
        return this.rowAsMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutboundRow row = (OutboundRow)o;
        return this.rowAsMap.equals(row.rowAsMap);
    }

    @Override
    public int hashCode() {
        return this.rowAsMap.hashCode();
    }

    public String toString() {
        return "OutboundRow[" + this.rowAsMap + "]";
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super SettableValue> action) {
        this.rowAsMap.forEach(action);
    }
}

