/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.query;

import java.util.Arrays;
import java.util.Collection;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Criteria {
    @Nullable
    private final Criteria previous;
    private final Combinator combinator;
    private final String column;
    private final Comparator comparator;
    @Nullable
    private final Object value;

    private Criteria(String column, Comparator comparator, @Nullable Object value) {
        this(null, Combinator.INITIAL, column, comparator, value);
    }

    private Criteria(@Nullable Criteria previous, Combinator combinator, String column, Comparator comparator, @Nullable Object value) {
        this.previous = previous;
        this.combinator = combinator;
        this.column = column;
        this.comparator = comparator;
        this.value = value;
    }

    public static CriteriaStep where(String column) {
        Assert.hasText((String)column, (String)"Column name must not be null or empty!");
        return new DefaultCriteriaStep(column);
    }

    public CriteriaStep and(final String column) {
        Assert.hasText((String)column, (String)"Column name must not be null or empty!");
        return new DefaultCriteriaStep(column){

            @Override
            protected Criteria createCriteria(Comparator comparator, Object value) {
                return new Criteria(Criteria.this, Combinator.AND, column, comparator, value);
            }
        };
    }

    public CriteriaStep or(final String column) {
        Assert.hasText((String)column, (String)"Column name must not be null or empty!");
        return new DefaultCriteriaStep(column){

            @Override
            protected Criteria createCriteria(Comparator comparator, Object value) {
                return new Criteria(Criteria.this, Combinator.OR, column, comparator, value);
            }
        };
    }

    @Nullable
    Criteria getPrevious() {
        return this.previous;
    }

    boolean hasPrevious() {
        return this.previous != null;
    }

    Combinator getCombinator() {
        return this.combinator;
    }

    String getColumn() {
        return this.column;
    }

    Comparator getComparator() {
        return this.comparator;
    }

    @Nullable
    Object getValue() {
        return this.value;
    }

    static class DefaultCriteriaStep
    implements CriteriaStep {
        private final String property;

        DefaultCriteriaStep(String property) {
            this.property = property;
        }

        @Override
        public Criteria is(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createCriteria(Comparator.EQ, value);
        }

        @Override
        public Criteria not(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createCriteria(Comparator.NEQ, value);
        }

        @Override
        public Criteria in(Object ... values) {
            Assert.notNull((Object)values, (String)"Values must not be null!");
            Assert.noNullElements((Object[])values, (String)"Values must not contain a null value!");
            if (values.length > 1 && values[1] instanceof Collection) {
                throw new InvalidDataAccessApiUsageException("You can only pass in one argument of type " + values[1].getClass().getName());
            }
            return this.createCriteria(Comparator.IN, Arrays.asList(values));
        }

        public Criteria in(Collection<?> values) {
            Assert.notNull(values, (String)"Values must not be null!");
            Assert.noNullElements((Object[])values.toArray(), (String)"Values must not contain a null value!");
            return this.createCriteria(Comparator.IN, values);
        }

        @Override
        public Criteria notIn(Object ... values) {
            Assert.notNull((Object)values, (String)"Values must not be null!");
            Assert.noNullElements((Object[])values, (String)"Values must not contain a null value!");
            if (values.length > 1 && values[1] instanceof Collection) {
                throw new InvalidDataAccessApiUsageException("You can only pass in one argument of type " + values[1].getClass().getName());
            }
            return this.createCriteria(Comparator.NOT_IN, Arrays.asList(values));
        }

        public Criteria notIn(Collection<?> values) {
            Assert.notNull(values, (String)"Values must not be null!");
            Assert.noNullElements((Object[])values.toArray(), (String)"Values must not contain a null value!");
            return this.createCriteria(Comparator.NOT_IN, values);
        }

        @Override
        public Criteria lessThan(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createCriteria(Comparator.LT, value);
        }

        @Override
        public Criteria lessThanOrEquals(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createCriteria(Comparator.LTE, value);
        }

        @Override
        public Criteria greaterThan(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createCriteria(Comparator.GT, value);
        }

        @Override
        public Criteria greaterThanOrEquals(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createCriteria(Comparator.GTE, value);
        }

        @Override
        public Criteria like(Object value) {
            Assert.notNull((Object)value, (String)"Value must not be null!");
            return this.createCriteria(Comparator.LIKE, value);
        }

        @Override
        public Criteria isNull() {
            return this.createCriteria(Comparator.IS_NULL, null);
        }

        @Override
        public Criteria isNotNull() {
            return this.createCriteria(Comparator.IS_NOT_NULL, null);
        }

        protected Criteria createCriteria(Comparator comparator, Object value) {
            return new Criteria(this.property, comparator, value);
        }
    }

    public static interface CriteriaStep {
        public Criteria is(Object var1);

        public Criteria not(Object var1);

        public Criteria in(Object ... var1);

        public Criteria in(Collection<? extends Object> var1);

        public Criteria notIn(Object ... var1);

        public Criteria notIn(Collection<? extends Object> var1);

        public Criteria lessThan(Object var1);

        public Criteria lessThanOrEquals(Object var1);

        public Criteria greaterThan(Object var1);

        public Criteria greaterThanOrEquals(Object var1);

        public Criteria like(Object var1);

        public Criteria isNull();

        public Criteria isNotNull();
    }

    static enum Combinator {
        INITIAL,
        AND,
        OR;

    }

    static enum Comparator {
        EQ,
        NEQ,
        LT,
        LTE,
        GT,
        GTE,
        IS_NULL,
        IS_NOT_NULL,
        LIKE,
        NOT_IN,
        IN;

    }
}

