/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.query;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.mapping.context.InvalidPersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.r2dbc.convert.R2dbcConverter;
import org.springframework.data.r2dbc.dialect.BindMarker;
import org.springframework.data.r2dbc.dialect.BindMarkers;
import org.springframework.data.r2dbc.dialect.MutableBindings;
import org.springframework.data.r2dbc.mapping.SettableValue;
import org.springframework.data.r2dbc.query.BoundCondition;
import org.springframework.data.r2dbc.query.Criteria;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.In;
import org.springframework.data.relational.core.sql.SQL;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class QueryMapper {
    private final R2dbcConverter converter;
    private final MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> mappingContext;

    public QueryMapper(R2dbcConverter converter) {
        Assert.notNull((Object)converter, (String)"R2dbcConverter must not be null!");
        this.converter = converter;
        this.mappingContext = converter.getMappingContext();
    }

    public Sort getMappedObject(Sort sort, @Nullable RelationalPersistentEntity<?> entity) {
        if (entity == null) {
            return sort;
        }
        ArrayList<Sort.Order> mappedOrder = new ArrayList<Sort.Order>();
        for (Sort.Order order : sort) {
            RelationalPersistentProperty persistentProperty = (RelationalPersistentProperty)entity.getPersistentProperty(order.getProperty());
            if (persistentProperty == null) {
                mappedOrder.add(order);
                continue;
            }
            mappedOrder.add(Sort.Order.by((String)persistentProperty.getColumnName()).with(order.getNullHandling()).with(order.getDirection()));
        }
        return Sort.by(mappedOrder);
    }

    public BoundCondition getMappedObject(BindMarkers markers, Criteria criteria, Table table, @Nullable RelationalPersistentEntity<?> entity) {
        Assert.notNull((Object)markers, (String)"BindMarkers must not be null!");
        Assert.notNull((Object)criteria, (String)"Criteria must not be null!");
        Assert.notNull((Object)table, (String)"Table must not be null!");
        Criteria current = criteria;
        MutableBindings bindings = new MutableBindings(markers);
        HashMap<Criteria, Criteria> forwardChain = new HashMap<Criteria, Criteria>();
        while (current.hasPrevious()) {
            forwardChain.put(current.getPrevious(), current);
            current = current.getPrevious();
        }
        Condition mapped = this.getCondition(current, bindings, table, entity);
        while (forwardChain.containsKey(current)) {
            Criteria nextCriteria = (Criteria)forwardChain.get(current);
            if (nextCriteria.getCombinator() == Criteria.Combinator.AND) {
                mapped = mapped.and(this.getCondition(nextCriteria, bindings, table, entity));
            }
            if (nextCriteria.getCombinator() == Criteria.Combinator.OR) {
                mapped = mapped.or(this.getCondition(nextCriteria, bindings, table, entity));
            }
            current = nextCriteria;
        }
        return new BoundCondition(bindings, mapped);
    }

    private Condition getCondition(Criteria criteria, MutableBindings bindings, Table table, @Nullable RelationalPersistentEntity<?> entity) {
        Class<?> typeHint;
        Object mappedValue;
        Field propertyField = this.createPropertyField(entity, criteria.getColumn(), this.mappingContext);
        Column column = table.column(propertyField.getMappedColumnName());
        TypeInformation actualType = propertyField.getTypeHint().getRequiredActualType();
        if (criteria.getValue() instanceof SettableValue) {
            SettableValue settableValue = (SettableValue)criteria.getValue();
            mappedValue = this.convertValue(settableValue.getValue(), propertyField.getTypeHint());
            typeHint = this.getTypeHint(mappedValue, actualType.getType(), settableValue);
        } else {
            mappedValue = this.convertValue(criteria.getValue(), propertyField.getTypeHint());
            typeHint = actualType.getType();
        }
        return this.createCondition(column, mappedValue, typeHint, bindings, criteria.getComparator());
    }

    @Nullable
    protected Object convertValue(@Nullable Object value, TypeInformation<?> typeInformation) {
        if (value == null) {
            return null;
        }
        if (value instanceof Iterable) {
            ArrayList<Object> mapped = new ArrayList<Object>();
            for (Object o : (Iterable)value) {
                mapped.add(this.converter.writeValue(o, typeInformation.getActualType()));
            }
            return mapped;
        }
        if (typeInformation.getType().isAssignableFrom(value.getClass()) || typeInformation.getType().isArray() && value.getClass().isArray()) {
            return value;
        }
        return this.converter.writeValue(value, typeInformation);
    }

    protected MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    private Condition createCondition(Column column, @Nullable Object mappedValue, Class<?> valueType, MutableBindings bindings, Criteria.Comparator comparator) {
        if (comparator.equals((Object)Criteria.Comparator.IS_NULL)) {
            return column.isNull();
        }
        if (comparator.equals((Object)Criteria.Comparator.IS_NOT_NULL)) {
            return column.isNotNull();
        }
        if (comparator == Criteria.Comparator.NOT_IN || comparator == Criteria.Comparator.IN) {
            In condition;
            if (mappedValue instanceof Iterable) {
                ArrayList<Expression> expressions = new ArrayList<Expression>(mappedValue instanceof Collection ? ((Collection)mappedValue).size() : 10);
                for (Object o : (Iterable)mappedValue) {
                    BindMarker bindMarker = bindings.nextMarker(column.getName());
                    expressions.add(this.bind(o, valueType, bindings, bindMarker));
                }
                condition = column.in(expressions.toArray(new Expression[0]));
            } else {
                BindMarker bindMarker = bindings.nextMarker(column.getName());
                Expression expression = this.bind(mappedValue, valueType, bindings, bindMarker);
                condition = column.in(new Expression[]{expression});
            }
            if (comparator == Criteria.Comparator.NOT_IN) {
                condition = condition.not();
            }
            return condition;
        }
        BindMarker bindMarker = bindings.nextMarker(column.getName());
        Expression expression = this.bind(mappedValue, valueType, bindings, bindMarker);
        switch (comparator) {
            case EQ: {
                return column.isEqualTo(expression);
            }
            case NEQ: {
                return column.isNotEqualTo(expression);
            }
            case LT: {
                return column.isLess(expression);
            }
            case LTE: {
                return column.isLessOrEqualTo(expression);
            }
            case GT: {
                return column.isGreater(expression);
            }
            case GTE: {
                return column.isGreaterOrEqualTo(expression);
            }
            case LIKE: {
                return column.like(expression);
            }
        }
        throw new UnsupportedOperationException("Comparator " + (Object)((Object)comparator) + " not supported");
    }

    Field createPropertyField(@Nullable RelationalPersistentEntity<?> entity, String key, MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> mappingContext) {
        return entity == null ? new Field(key) : new MetadataBackedField(key, entity, mappingContext);
    }

    Class<?> getTypeHint(Object mappedValue, Class<?> propertyType, SettableValue settableValue) {
        if (mappedValue == null || propertyType.equals(Object.class)) {
            return settableValue.getType();
        }
        if (mappedValue.getClass().equals(settableValue.getValue().getClass())) {
            return settableValue.getType();
        }
        return propertyType;
    }

    private Expression bind(@Nullable Object mappedValue, Class<?> valueType, MutableBindings bindings, BindMarker bindMarker) {
        if (mappedValue != null) {
            bindings.bind(bindMarker, mappedValue);
        } else {
            bindings.bindNull(bindMarker, valueType);
        }
        return SQL.bindMarker((String)bindMarker.getPlaceholder());
    }

    protected static class MetadataBackedField
    extends Field {
        private final RelationalPersistentEntity<?> entity;
        private final MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> mappingContext;
        private final RelationalPersistentProperty property;
        @Nullable
        private final PersistentPropertyPath<RelationalPersistentProperty> path;

        protected MetadataBackedField(String name, RelationalPersistentEntity<?> entity, MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> context) {
            this(name, entity, context, null);
        }

        protected MetadataBackedField(String name, RelationalPersistentEntity<?> entity, MappingContext<? extends RelationalPersistentEntity<?>, RelationalPersistentProperty> context, @Nullable RelationalPersistentProperty property) {
            super(name);
            Assert.notNull(entity, (String)"MongoPersistentEntity must not be null!");
            this.entity = entity;
            this.mappingContext = context;
            this.path = this.getPath(name);
            this.property = this.path == null ? property : (RelationalPersistentProperty)this.path.getLeafProperty();
        }

        @Override
        public String getMappedColumnName() {
            return this.path == null ? this.name : this.path.toDotPath(RelationalPersistentProperty::getColumnName);
        }

        @Nullable
        private PersistentPropertyPath<RelationalPersistentProperty> getPath(String pathExpression) {
            try {
                PropertyPath path = PropertyPath.from((String)pathExpression, (TypeInformation)this.entity.getTypeInformation());
                if (this.isPathToJavaLangClassProperty(path)) {
                    return null;
                }
                return this.mappingContext.getPersistentPropertyPath(path);
            }
            catch (PropertyReferenceException | InvalidPersistentPropertyPath e) {
                return null;
            }
        }

        private boolean isPathToJavaLangClassProperty(PropertyPath path) {
            return path.getType().equals(Class.class) && path.getLeafProperty().getOwningType().getType().equals(Class.class);
        }

        @Override
        public TypeInformation<?> getTypeHint() {
            if (this.property == null) {
                return super.getTypeHint();
            }
            if (this.property.getType().isPrimitive()) {
                return ClassTypeInformation.from((Class)ClassUtils.resolvePrimitiveIfNecessary((Class)this.property.getType()));
            }
            if (this.property.getType().isArray()) {
                return this.property.getTypeInformation();
            }
            if (this.property.getType().isInterface() || Modifier.isAbstract(this.property.getType().getModifiers())) {
                return ClassTypeInformation.OBJECT;
            }
            return this.property.getTypeInformation();
        }
    }

    protected static class Field {
        protected final String name;

        public Field(String name) {
            Assert.hasText((String)name, (String)"Name must not be null!");
            this.name = name;
        }

        public String getMappedColumnName() {
            return this.name;
        }

        public TypeInformation<?> getTypeHint() {
            return ClassTypeInformation.OBJECT;
        }
    }
}

