/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.convert;

import io.r2dbc.spi.ColumnMetadata;
import io.r2dbc.spi.Row;
import io.r2dbc.spi.RowMetadata;
import java.util.Collection;
import java.util.Map;
import java.util.function.BiFunction;
import org.springframework.data.r2dbc.convert.IterableUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.LinkedCaseInsensitiveMap;

public class ColumnMapRowMapper
implements BiFunction<Row, RowMetadata, Map<String, Object>> {
    public static final ColumnMapRowMapper INSTANCE = new ColumnMapRowMapper();

    @Override
    public Map<String, Object> apply(Row row, RowMetadata rowMetadata) {
        Collection<ColumnMetadata> columns = IterableUtils.toCollection(rowMetadata.getColumnMetadatas());
        int columnCount = columns.size();
        Map<String, Object> mapOfColValues = this.createColumnMap(columnCount);
        int index = 0;
        for (ColumnMetadata column : columns) {
            String key = this.getColumnKey(column.getName());
            Object obj = this.getColumnValue(row, index++);
            mapOfColValues.put(key, obj);
        }
        return mapOfColValues;
    }

    protected Map<String, Object> createColumnMap(int columnCount) {
        return new LinkedCaseInsensitiveMap(columnCount);
    }

    protected String getColumnKey(String columnName) {
        return columnName;
    }

    @Nullable
    protected Object getColumnValue(Row row, int index) {
        return row.get(index);
    }
}

