/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.connectionfactory;

import io.r2dbc.spi.Connection;
import org.springframework.data.r2dbc.connectionfactory.ConnectionHandle;
import org.springframework.data.r2dbc.connectionfactory.SimpleConnectionHandle;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.ResourceHolderSupport;
import org.springframework.util.Assert;

public class ConnectionHolder
extends ResourceHolderSupport {
    @Nullable
    private ConnectionHandle connectionHandle;
    @Nullable
    private Connection currentConnection;
    private boolean transactionActive;

    public ConnectionHolder(Connection connection) {
        this(connection, false);
    }

    public ConnectionHolder(Connection connection, boolean transactionActive) {
        this.connectionHandle = new SimpleConnectionHandle(connection);
        this.transactionActive = transactionActive;
    }

    @Nullable
    public ConnectionHandle getConnectionHandle() {
        return this.connectionHandle;
    }

    protected boolean hasConnection() {
        return this.connectionHandle != null;
    }

    protected void setTransactionActive(boolean transactionActive) {
        this.transactionActive = transactionActive;
    }

    protected boolean isTransactionActive() {
        return this.transactionActive;
    }

    protected void setConnection(@Nullable Connection connection) {
        if (this.currentConnection != null) {
            if (this.connectionHandle != null) {
                this.connectionHandle.releaseConnection(this.currentConnection);
            }
            this.currentConnection = null;
        }
        this.connectionHandle = connection != null ? new SimpleConnectionHandle(connection) : null;
    }

    public Connection getConnection() {
        Assert.notNull((Object)this.connectionHandle, (String)"Active Connection is required");
        if (this.currentConnection == null) {
            this.currentConnection = this.connectionHandle.getConnection();
        }
        return this.currentConnection;
    }

    public void released() {
        super.released();
        if (!this.isOpen() && this.currentConnection != null) {
            if (this.connectionHandle != null) {
                this.connectionHandle.releaseConnection(this.currentConnection);
            }
            this.currentConnection = null;
        }
    }

    public void clear() {
        super.clear();
        this.transactionActive = false;
    }
}

