/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.support;

import io.r2dbc.spi.R2dbcException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.r2dbc.UncategorizedR2dbcException;
import org.springframework.data.r2dbc.support.R2dbcExceptionTranslator;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractFallbackR2dbcExceptionTranslator
implements R2dbcExceptionTranslator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    @Nullable
    private R2dbcExceptionTranslator fallbackTranslator;

    public void setFallbackTranslator(@Nullable R2dbcExceptionTranslator fallback) {
        this.fallbackTranslator = fallback;
    }

    @Nullable
    public R2dbcExceptionTranslator getFallbackTranslator() {
        return this.fallbackTranslator;
    }

    @Override
    @NonNull
    public DataAccessException translate(String task, @Nullable String sql, R2dbcException ex) {
        Assert.notNull((Object)((Object)ex), (String)"Cannot translate a null R2dbcException");
        DataAccessException dae = this.doTranslate(task, sql, ex);
        if (dae != null) {
            return dae;
        }
        R2dbcExceptionTranslator fallback = this.getFallbackTranslator();
        if (fallback != null && (dae = fallback.translate(task, sql, ex)) != null) {
            return dae;
        }
        return new UncategorizedR2dbcException(task, sql, ex);
    }

    @Nullable
    protected abstract DataAccessException doTranslate(String var1, @Nullable String var2, R2dbcException var3);

    protected String buildMessage(String task, @Nullable String sql, R2dbcException ex) {
        return task + "; " + (sql != null ? "SQL [" + sql + "]; " : "") + ex.getMessage();
    }
}

