/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.connectionfactory;

import io.r2dbc.spi.Connection;
import io.r2dbc.spi.ConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.data.r2dbc.connectionfactory.ConnectionProxy;
import org.springframework.data.r2dbc.connectionfactory.DelegatingConnectionFactory;
import org.springframework.data.r2dbc.connectionfactory.SmartConnectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

@Deprecated
public abstract class ConnectionFactoryUtils {
    public static final int CONNECTION_SYNCHRONIZATION_ORDER = 1000;
    private static final Log logger = LogFactory.getLog(ConnectionFactoryUtils.class);

    private ConnectionFactoryUtils() {
    }

    public static Mono<Connection> getConnection(ConnectionFactory connectionFactory) {
        return org.springframework.r2dbc.connection.ConnectionFactoryUtils.getConnection((ConnectionFactory)connectionFactory);
    }

    public static Mono<Connection> doGetConnection(ConnectionFactory connectionFactory) {
        return org.springframework.r2dbc.connection.ConnectionFactoryUtils.doGetConnection((ConnectionFactory)connectionFactory);
    }

    public static Mono<Void> releaseConnection(Connection con, ConnectionFactory connectionFactory) {
        return ConnectionFactoryUtils.doReleaseConnection(con, connectionFactory).onErrorMap(e -> new DataAccessResourceFailureException("Failed to close R2DBC Connection", e));
    }

    public static Mono<Void> doReleaseConnection(Connection connection, ConnectionFactory connectionFactory) {
        return org.springframework.r2dbc.connection.ConnectionFactoryUtils.doReleaseConnection((Connection)connection, (ConnectionFactory)connectionFactory);
    }

    public static Mono<Void> closeConnection(Connection connection, ConnectionFactory connectionFactory) {
        Assert.notNull((Object)connection, (String)"Connection must not be null!");
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null!");
        return ConnectionFactoryUtils.doCloseConnection(connection, connectionFactory).onErrorMap(e -> new DataAccessResourceFailureException("Failed to obtain R2DBC Connection", e));
    }

    public static Mono<Void> doCloseConnection(Connection connection, @Nullable ConnectionFactory connectionFactory) {
        if (!(connectionFactory instanceof SmartConnectionFactory) || ((SmartConnectionFactory)connectionFactory).shouldClose(connection)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Closing R2DBC Connection");
            }
            return Mono.from((Publisher)connection.close());
        }
        return Mono.empty();
    }

    public static Mono<ConnectionFactory> currentConnectionFactory(ConnectionFactory connectionFactory) {
        return org.springframework.r2dbc.connection.ConnectionFactoryUtils.currentConnectionFactory((ConnectionFactory)connectionFactory);
    }

    public static Connection getTargetConnection(Connection con) {
        Connection conToUse = con;
        while (conToUse instanceof ConnectionProxy) {
            conToUse = ((ConnectionProxy)conToUse).getTargetConnection();
        }
        return conToUse;
    }

    private static int getConnectionSynchronizationOrder(ConnectionFactory connectionFactory) {
        int order = 1000;
        ConnectionFactory current = connectionFactory;
        while (current instanceof DelegatingConnectionFactory) {
            --order;
            current = ((DelegatingConnectionFactory)current).getTargetConnectionFactory();
        }
        return order;
    }
}

