/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.mapping;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.r2dbc.core.Parameter;
import org.springframework.util.Assert;

public class OutboundRow
implements Map<SqlIdentifier, Parameter>,
Cloneable {
    private final Map<SqlIdentifier, Parameter> rowAsMap;

    public OutboundRow() {
        this.rowAsMap = new LinkedHashMap<SqlIdentifier, Parameter>();
    }

    public OutboundRow(Map<String, Parameter> map) {
        Assert.notNull(map, (String)"Map must not be null");
        this.rowAsMap = new LinkedHashMap<SqlIdentifier, Parameter>(map.size());
        map.forEach((? super K s, ? super V Parameter2) -> this.rowAsMap.put(SqlIdentifier.unquoted((String)s), (Parameter)Parameter2));
    }

    private OutboundRow(OutboundRow map) {
        this.rowAsMap = new LinkedHashMap<SqlIdentifier, Parameter>(map.size());
        this.rowAsMap.putAll(map);
    }

    public OutboundRow(String key, Parameter value) {
        this(SqlIdentifier.unquoted((String)key), value);
    }

    public OutboundRow(SqlIdentifier key, Parameter value) {
        this.rowAsMap = new LinkedHashMap<SqlIdentifier, Parameter>();
        this.rowAsMap.put(key, value);
    }

    public OutboundRow append(String key, Parameter value) {
        return this.append(SqlIdentifier.unquoted((String)key), value);
    }

    public OutboundRow append(SqlIdentifier key, Parameter value) {
        this.rowAsMap.put(key, value);
        return this;
    }

    @Override
    public int size() {
        return this.rowAsMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.rowAsMap.isEmpty();
    }

    protected OutboundRow clone() {
        return new OutboundRow(this);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.rowAsMap.containsKey(OutboundRow.convertKeyIfNecessary(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.rowAsMap.containsValue(value);
    }

    @Override
    public Parameter get(Object key) {
        return this.rowAsMap.get(OutboundRow.convertKeyIfNecessary(key));
    }

    @Override
    public Parameter put(String key, Parameter value) {
        return this.put(SqlIdentifier.unquoted((String)key), value);
    }

    @Override
    public Parameter put(SqlIdentifier key, Parameter value) {
        return this.rowAsMap.put(key, value);
    }

    @Override
    public Parameter remove(Object key) {
        return this.rowAsMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends SqlIdentifier, ? extends Parameter> m) {
        this.rowAsMap.putAll(m);
    }

    @Override
    public void clear() {
        this.rowAsMap.clear();
    }

    @Override
    public Set<SqlIdentifier> keySet() {
        return this.rowAsMap.keySet();
    }

    @Override
    public Collection<Parameter> values() {
        return this.rowAsMap.values();
    }

    @Override
    public Set<Map.Entry<SqlIdentifier, Parameter>> entrySet() {
        return this.rowAsMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutboundRow row = (OutboundRow)o;
        return this.rowAsMap.equals(row.rowAsMap);
    }

    @Override
    public int hashCode() {
        return this.rowAsMap.hashCode();
    }

    public String toString() {
        return "OutboundRow[" + this.rowAsMap + "]";
    }

    @Override
    public void forEach(BiConsumer<? super SqlIdentifier, ? super Parameter> action) {
        this.rowAsMap.forEach(action);
    }

    private static Object convertKeyIfNecessary(Object key) {
        return key instanceof String ? SqlIdentifier.unquoted((String)((String)key)) : key;
    }
}

