/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.r2dbc.convert;

import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.r2dbc.convert.SequenceEntityCallbackDelegate;
import org.springframework.data.r2dbc.dialect.R2dbcDialect;
import org.springframework.data.r2dbc.mapping.OutboundRow;
import org.springframework.data.r2dbc.mapping.event.BeforeSaveCallback;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.r2dbc.core.DatabaseClient;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class IdGeneratingEntityCallback
implements BeforeSaveCallback<Object> {
    private final MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context;
    private final SequenceEntityCallbackDelegate delegate;

    public IdGeneratingEntityCallback(MappingContext<RelationalPersistentEntity<?>, ? extends RelationalPersistentProperty> context, R2dbcDialect dialect, DatabaseClient databaseClient) {
        this.context = context;
        this.delegate = new SequenceEntityCallbackDelegate(dialect, databaseClient);
    }

    @Override
    public Mono<Object> onBeforeSave(Object entity, OutboundRow row, SqlIdentifier table) {
        Assert.notNull((Object)entity, (String)"Entity must not be null");
        RelationalPersistentEntity persistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(entity.getClass());
        if (!persistentEntity.hasIdProperty()) {
            return Mono.just((Object)entity);
        }
        RelationalPersistentProperty property = (RelationalPersistentProperty)persistentEntity.getRequiredIdProperty();
        PersistentPropertyAccessor accessor = persistentEntity.getPropertyAccessor(entity);
        if (!persistentEntity.isNew(entity) || this.delegate.hasValue((PersistentProperty<?>)property, (PersistentPropertyAccessor<Object>)accessor) || !property.hasSequence()) {
            return Mono.just((Object)entity);
        }
        Mono<Object> idGenerator = this.delegate.generateSequenceValue(property, row, (PersistentPropertyAccessor<Object>)accessor);
        return idGenerator.defaultIfEmpty(entity);
    }
}

