/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import java.util.Arrays;
import java.util.Set;
import org.springframework.cache.Cache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.util.Assert;

class RedisCache
implements Cache {
    private static final int PAGE_SIZE = 128;
    private final String name;
    private final RedisTemplate template;
    private final byte[] prefix;
    private final byte[] setName;
    private final byte[] cacheLockName;
    private long WAIT_FOR_LOCK = 300L;
    private final long expiration;

    RedisCache(String name, byte[] prefix, RedisTemplate<? extends Object, ? extends Object> template, long expiration) {
        Assert.hasText((String)name, (String)"non-empty cache name is required");
        this.name = name;
        this.template = template;
        this.prefix = prefix;
        this.expiration = expiration;
        StringRedisSerializer stringSerializer = new StringRedisSerializer();
        this.setName = stringSerializer.serialize(name + "~keys");
        this.cacheLockName = stringSerializer.serialize(name + "~lock");
    }

    public String getName() {
        return this.name;
    }

    public Object getNativeCache() {
        return this.template;
    }

    public Cache.ValueWrapper get(final Object key) {
        return this.template.execute(new RedisCallback<Cache.ValueWrapper>(){

            @Override
            public Cache.ValueWrapper doInRedis(RedisConnection connection) throws DataAccessException {
                RedisCache.this.waitForLock(connection);
                byte[] bs = connection.get(RedisCache.this.computeKey(key));
                byte[] value = RedisCache.this.template.getValueSerializer() != null ? (Object)RedisCache.this.template.getValueSerializer().deserialize(bs) : bs;
                return bs == null ? null : new SimpleValueWrapper((Object)value);
            }
        }, true);
    }

    public <T> T get(Object key, Class<T> type) {
        Cache.ValueWrapper wrapper = this.get(key);
        return (T)(wrapper == null ? null : wrapper.get());
    }

    public void put(Object key, final Object value) {
        final byte[] k = this.computeKey(key);
        this.template.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                RedisCache.this.waitForLock(connection);
                connection.multi();
                byte[] v = RedisCache.this.template.getValueSerializer() == null && value instanceof byte[] ? (byte[])value : RedisCache.this.template.getValueSerializer().serialize(value);
                connection.set(k, v);
                connection.zAdd(RedisCache.this.setName, 0.0, k);
                if (RedisCache.this.expiration > 0L) {
                    connection.expire(k, RedisCache.this.expiration);
                    connection.expire(RedisCache.this.setName, RedisCache.this.expiration);
                }
                connection.exec();
                return null;
            }
        }, true);
    }

    public void evict(Object key) {
        final byte[] k = this.computeKey(key);
        this.template.execute(new RedisCallback<Object>(){

            @Override
            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                connection.del(new byte[][]{k});
                connection.zRem(RedisCache.this.setName, new byte[][]{k});
                return null;
            }
        }, true);
    }

    public void clear() {
        this.template.execute(new RedisCallback<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object doInRedis(RedisConnection connection) throws DataAccessException {
                Object var4_4;
                if (connection.exists(RedisCache.this.cacheLockName).booleanValue()) {
                    return null;
                }
                try {
                    connection.set(RedisCache.this.cacheLockName, RedisCache.this.cacheLockName);
                    int offset = 0;
                    boolean finished = false;
                    do {
                        Set<byte[]> keys;
                        finished = (keys = connection.zRange(RedisCache.this.setName, offset * 128, (offset + 1) * 128 - 1)).size() < 128;
                        ++offset;
                        if (keys.isEmpty()) continue;
                        connection.del((byte[][])keys.toArray((T[])new byte[keys.size()][]));
                    } while (!finished);
                    connection.del(new byte[][]{RedisCache.this.setName});
                    var4_4 = null;
                }
                catch (Throwable throwable) {
                    connection.del(new byte[][]{RedisCache.this.cacheLockName});
                    throw throwable;
                }
                connection.del(new byte[][]{RedisCache.this.cacheLockName});
                return var4_4;
            }
        }, true);
    }

    private byte[] computeKey(Object key) {
        if (this.template.getKeySerializer() == null && key instanceof byte[]) {
            return (byte[])key;
        }
        byte[] k = this.template.getKeySerializer().serialize(key);
        if (this.prefix == null || this.prefix.length == 0) {
            return k;
        }
        byte[] result = Arrays.copyOf(this.prefix, this.prefix.length + k.length);
        System.arraycopy(k, 0, result, this.prefix.length, k.length);
        return result;
    }

    private boolean waitForLock(RedisConnection connection) {
        boolean retry;
        boolean foundLock = false;
        do {
            retry = false;
            if (!connection.exists(this.cacheLockName).booleanValue()) continue;
            foundLock = true;
            try {
                Thread.sleep(this.WAIT_FOR_LOCK);
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            retry = true;
        } while (retry);
        return foundLock;
    }
}

