/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.convert;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.convert.LongToBooleanConverter;
import org.springframework.data.redis.connection.convert.MapToPropertiesConverter;
import org.springframework.data.redis.connection.convert.StringToDataTypeConverter;
import org.springframework.data.redis.connection.convert.StringToPropertiesConverter;
import org.springframework.util.NumberUtils;

public abstract class Converters {
    private static final byte[] ONE = new byte[]{49};
    private static final byte[] ZERO = new byte[]{48};
    private static final Converter<String, Properties> STRING_TO_PROPS = new StringToPropertiesConverter();
    private static final Converter<Long, Boolean> LONG_TO_BOOLEAN = new LongToBooleanConverter();
    private static final Converter<String, DataType> STRING_TO_DATA_TYPE = new StringToDataTypeConverter();
    private static final Converter<Map<?, ?>, Properties> MAP_TO_PROPERTIES = MapToPropertiesConverter.INSTANCE;

    public static Converter<String, Properties> stringToProps() {
        return STRING_TO_PROPS;
    }

    public static Converter<Long, Boolean> longToBoolean() {
        return LONG_TO_BOOLEAN;
    }

    public static Converter<String, DataType> stringToDataType() {
        return STRING_TO_DATA_TYPE;
    }

    public static Properties toProperties(String source) {
        return (Properties)STRING_TO_PROPS.convert((Object)source);
    }

    public static Properties toProperties(Map<?, ?> source) {
        return (Properties)MAP_TO_PROPERTIES.convert(source);
    }

    public static Boolean toBoolean(Long source) {
        return (Boolean)LONG_TO_BOOLEAN.convert((Object)source);
    }

    public static DataType toDataType(String source) {
        return (DataType)((Object)STRING_TO_DATA_TYPE.convert((Object)source));
    }

    public static byte[] toBit(Boolean source) {
        return source != false ? ONE : ZERO;
    }

    public static List<Object> toObjects(Set<RedisZSetCommands.Tuple> tuples) {
        ArrayList<Object> tupleArgs = new ArrayList<Object>(tuples.size() * 2);
        for (RedisZSetCommands.Tuple tuple : tuples) {
            tupleArgs.add(tuple.getScore());
            tupleArgs.add(tuple.getValue());
        }
        return tupleArgs;
    }

    public static Long toTimeMillis(String seconds, String microseconds) {
        return (Long)NumberUtils.parseNumber((String)seconds, Long.class) * 1000L + (Long)NumberUtils.parseNumber((String)microseconds, Long.class) / 1000L;
    }
}

