/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.nio.charset.Charset;
import org.springframework.data.redis.core.RedisKeyspaceEvent;
import org.springframework.data.redis.core.convert.MappingRedisConverter;

public class RedisKeyExpiredEvent<T>
extends RedisKeyspaceEvent {
    static final Charset CHARSET = Charset.forName("UTF-8");
    private final MappingRedisConverter.BinaryKeyspaceIdentifier objectId;
    private final Object value;

    public RedisKeyExpiredEvent(byte[] key) {
        this(key, null);
    }

    public RedisKeyExpiredEvent(byte[] key, Object value) {
        this(null, key, value);
    }

    public RedisKeyExpiredEvent(String channel, byte[] key, Object value) {
        super(channel, key);
        this.objectId = MappingRedisConverter.BinaryKeyspaceIdentifier.isValid(key) ? MappingRedisConverter.BinaryKeyspaceIdentifier.of(key) : null;
        this.value = value;
    }

    public String getKeyspace() {
        return this.objectId != null ? new String(this.objectId.getKeyspace(), CHARSET) : null;
    }

    public byte[] getId() {
        return this.objectId != null ? this.objectId.getId() : this.getSource();
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return "RedisKeyExpiredEvent [keyspace=" + this.getKeyspace() + ", id=" + this.getId() + "]";
    }
}

