/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.util.Assert;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

public class RedisClusterConfiguration {
    private static final String REDIS_CLUSTER_NODES_CONFIG_PROPERTY = "spring.redis.cluster.nodes";
    private static final String REDIS_CLUSTER_MAX_REDIRECTS_CONFIG_PROPERTY = "spring.redis.cluster.max-redirects";
    private Set<RedisNode> clusterNodes;
    private Integer maxRedirects;

    public RedisClusterConfiguration() {
        this((PropertySource<?>)new MapPropertySource("RedisClusterConfiguration", Collections.emptyMap()));
    }

    public RedisClusterConfiguration(Collection<String> clusterNodes) {
        this((PropertySource<?>)new MapPropertySource("RedisClusterConfiguration", RedisClusterConfiguration.asMap(clusterNodes, -1L, -1, null)));
    }

    public RedisClusterConfiguration(PropertySource<?> propertySource) {
        Assert.notNull(propertySource, (String)"PropertySource must not be null!");
        this.clusterNodes = new LinkedHashSet<RedisNode>();
        if (propertySource.containsProperty(REDIS_CLUSTER_NODES_CONFIG_PROPERTY)) {
            this.appendClusterNodes(StringUtils.commaDelimitedListToSet((String)propertySource.getProperty(REDIS_CLUSTER_NODES_CONFIG_PROPERTY).toString()));
        }
        if (propertySource.containsProperty(REDIS_CLUSTER_MAX_REDIRECTS_CONFIG_PROPERTY)) {
            this.maxRedirects = (Integer)NumberUtils.parseNumber((String)propertySource.getProperty(REDIS_CLUSTER_MAX_REDIRECTS_CONFIG_PROPERTY).toString(), Integer.class);
        }
    }

    public void setClusterNodes(Iterable<RedisNode> nodes) {
        Assert.notNull(nodes, (String)"Cannot set cluster nodes to 'null'.");
        this.clusterNodes.clear();
        for (RedisNode clusterNode : nodes) {
            this.addClusterNode(clusterNode);
        }
    }

    public Set<RedisNode> getClusterNodes() {
        return Collections.unmodifiableSet(this.clusterNodes);
    }

    public void addClusterNode(RedisNode node) {
        Assert.notNull((Object)node, (String)"ClusterNode must not be 'null'.");
        this.clusterNodes.add(node);
    }

    public RedisClusterConfiguration clusterNode(RedisNode node) {
        this.clusterNodes.add(node);
        return this;
    }

    public Integer getMaxRedirects() {
        return this.maxRedirects != null && this.maxRedirects > Integer.MIN_VALUE ? this.maxRedirects : null;
    }

    public void setMaxRedirects(int maxRedirects) {
        Assert.isTrue((maxRedirects >= 0 ? 1 : 0) != 0, (String)"MaxRedirects must be greater or equal to 0");
        this.maxRedirects = maxRedirects;
    }

    public RedisClusterConfiguration clusterNode(String host, Integer port) {
        return this.clusterNode(new RedisNode(host, port));
    }

    private void appendClusterNodes(Set<String> hostAndPorts) {
        for (String hostAndPort : hostAndPorts) {
            this.addClusterNode(this.readHostAndPortFromString(hostAndPort));
        }
    }

    private RedisNode readHostAndPortFromString(String hostAndPort) {
        String[] args = StringUtils.split((String)hostAndPort, (String)":");
        Assert.notNull((Object)args, (String)"HostAndPort need to be seperated by  ':'.");
        Assert.isTrue((args.length == 2 ? 1 : 0) != 0, (String)"Host and Port String needs to specified as host:port");
        return new RedisNode(args[0], Integer.valueOf(args[1]));
    }

    private static Map<String, Object> asMap(Collection<String> clusterHostAndPorts, long timeout, int redirects, String password) {
        Assert.notNull(clusterHostAndPorts, (String)"ClusterHostAndPorts must not be null!");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(REDIS_CLUSTER_NODES_CONFIG_PROPERTY, StringUtils.collectionToCommaDelimitedString(clusterHostAndPorts));
        if (redirects >= 0) {
            map.put(REDIS_CLUSTER_MAX_REDIRECTS_CONFIG_PROPERTY, redirects);
        }
        return map;
    }
}

