/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.beans.ConstructorProperties;
import java.util.concurrent.Future;
import lombok.NonNull;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisHyperLogLogCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceResult;
import org.springframework.util.Assert;

class LettuceHyperLogLogCommands
implements RedisHyperLogLogCommands {
    @NonNull
    private final LettuceConnection connection;

    @Override
    public Long pfAdd(byte[] key, byte[] ... values) {
        Assert.notEmpty((Object[])values, (String)"PFADD requires at least one non 'null' value.");
        Assert.noNullElements((Object[])values, (String)"Values for PFADD must not contain 'null'.");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().pfadd((Object)key, (Object[])values)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().pfadd((Object)key, (Object[])values)));
                return null;
            }
            RedisClusterCommands<byte[], byte[]> connection = this.getConnection();
            return connection.pfadd((Object)key, (Object[])values);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long pfCount(byte[] ... keys) {
        Assert.notEmpty((Object[])keys, (String)"PFCOUNT requires at least one non 'null' key.");
        Assert.noNullElements((Object[])keys, (String)"Keys for PFCOUNT must not contain 'null'.");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().pfcount((Object[])keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().pfcount((Object[])keys)));
                return null;
            }
            RedisClusterCommands<byte[], byte[]> connection = this.getConnection();
            return connection.pfcount((Object[])keys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public void pfMerge(byte[] destinationKey, byte[] ... sourceKeys) {
        Assert.notNull((Object)destinationKey, (String)"Destination key must not be null");
        Assert.notNull((Object)sourceKeys, (String)"Source keys must not be null");
        Assert.noNullElements((Object[])sourceKeys, (String)"Keys for PFMERGE must not contain 'null'.");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().pfmerge((Object)destinationKey, (Object[])sourceKeys)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().pfmerge((Object)destinationKey, (Object[])sourceKeys)));
                return;
            }
            RedisClusterCommands<byte[], byte[]> connection = this.getConnection();
            connection.pfmerge((Object)destinationKey, (Object[])sourceKeys);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void pipeline(LettuceResult result) {
        this.connection.pipeline(result);
    }

    private void transaction(LettuceResult result) {
        this.connection.transaction(result);
    }

    private RedisClusterAsyncCommands<byte[], byte[]> getAsyncConnection() {
        return this.connection.getAsyncConnection();
    }

    public RedisClusterCommands<byte[], byte[]> getConnection() {
        return this.connection.getConnection();
    }

    protected DataAccessException convertLettuceAccessException(Exception ex) {
        return this.connection.convertLettuceAccessException(ex);
    }

    @ConstructorProperties(value={"connection"})
    public LettuceHyperLogLogCommands(@NonNull LettuceConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        this.connection = connection;
    }
}

