/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.springframework.cache.transaction.AbstractTransactionSupportingCacheManager;
import org.springframework.data.redis.cache.DefaultRedisCacheWriter;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class RedisCacheManager
extends AbstractTransactionSupportingCacheManager {
    private final RedisCacheWriter cacheWriter;
    private final RedisCacheConfiguration defaultCacheConfig;
    private final Map<String, RedisCacheConfiguration> initialCacheConfiguration;

    public RedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration) {
        Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null!");
        Assert.notNull((Object)defaultCacheConfiguration, (String)"DefaultCacheConfiguration must not be null!");
        this.cacheWriter = cacheWriter;
        this.defaultCacheConfig = defaultCacheConfiguration;
        this.initialCacheConfiguration = new LinkedHashMap<String, RedisCacheConfiguration>();
    }

    public RedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, String ... initialCacheNames) {
        this(cacheWriter, defaultCacheConfiguration);
        for (String cacheName : initialCacheNames) {
            this.initialCacheConfiguration.put(cacheName, defaultCacheConfiguration);
        }
    }

    public RedisCacheManager(RedisCacheWriter cacheWriter, RedisCacheConfiguration defaultCacheConfiguration, Map<String, RedisCacheConfiguration> initialCacheConfigurations) {
        this(cacheWriter, defaultCacheConfiguration);
        Assert.notNull(initialCacheConfigurations, (String)"InitialCacheConfigurations must not be null!");
        this.initialCacheConfiguration.putAll(initialCacheConfigurations);
    }

    public static RedisCacheManager create(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null!");
        return new RedisCacheManager(new DefaultRedisCacheWriter(connectionFactory), RedisCacheConfiguration.defaultCacheConfig());
    }

    public static RedisCacheManagerBuilder builder(RedisConnectionFactory connectionFactory) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null!");
        return RedisCacheManagerBuilder.fromConnectionFactory(connectionFactory);
    }

    public static RedisCacheManagerBuilder builder(RedisCacheWriter cacheWriter) {
        Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null!");
        return RedisCacheManagerBuilder.fromCacheWriter(cacheWriter);
    }

    protected Collection<RedisCache> loadCaches() {
        LinkedList<RedisCache> caches = new LinkedList<RedisCache>();
        for (Map.Entry<String, RedisCacheConfiguration> entry : this.initialCacheConfiguration.entrySet()) {
            caches.add(this.createRedisCache(entry.getKey(), entry.getValue()));
        }
        return caches;
    }

    protected RedisCache getMissingCache(String name) {
        return this.createRedisCache(name, this.defaultCacheConfig);
    }

    public Map<String, RedisCacheConfiguration> getCacheConfigurations() {
        HashMap configurationMap = new HashMap(this.getCacheNames().size());
        this.getCacheNames().forEach(it -> {
            RedisCache cache = (RedisCache)((Object)((Object)RedisCache.class.cast(this.lookupCache((String)it))));
            configurationMap.put(it, cache != null ? cache.getCacheConfiguration() : null);
        });
        return Collections.unmodifiableMap(configurationMap);
    }

    protected RedisCache createRedisCache(String name, @Nullable RedisCacheConfiguration cacheConfig) {
        return new RedisCache(name, this.cacheWriter, cacheConfig != null ? cacheConfig : this.defaultCacheConfig);
    }

    public static class RedisCacheManagerBuilder {
        private final RedisCacheWriter cacheWriter;
        private RedisCacheConfiguration defaultCacheConfiguration = RedisCacheConfiguration.defaultCacheConfig();
        private final Map<String, RedisCacheConfiguration> intialCaches = new LinkedHashMap<String, RedisCacheConfiguration>();
        private boolean enableTransactions;

        private RedisCacheManagerBuilder(RedisCacheWriter cacheWriter) {
            this.cacheWriter = cacheWriter;
        }

        public static RedisCacheManagerBuilder fromConnectionFactory(RedisConnectionFactory connectionFactory) {
            Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null!");
            return RedisCacheManager.builder(new DefaultRedisCacheWriter(connectionFactory));
        }

        public static RedisCacheManagerBuilder fromCacheWriter(RedisCacheWriter cacheWriter) {
            Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null!");
            return new RedisCacheManagerBuilder(cacheWriter);
        }

        public RedisCacheManagerBuilder cacheDefaults(RedisCacheConfiguration defaultCacheConfiguration) {
            Assert.notNull((Object)defaultCacheConfiguration, (String)"DefaultCacheConfiguration must not be null!");
            this.defaultCacheConfiguration = defaultCacheConfiguration;
            return this;
        }

        public RedisCacheManagerBuilder transactionAware() {
            this.enableTransactions = true;
            return this;
        }

        public RedisCacheManagerBuilder initialCacheNames(Set<String> cacheNames) {
            Assert.notNull(cacheNames, (String)"CacheNames must not be null!");
            LinkedHashMap<String, RedisCacheConfiguration> cacheConfigMap = new LinkedHashMap<String, RedisCacheConfiguration>(cacheNames.size());
            cacheNames.forEach(it -> cacheConfigMap.put((String)it, this.defaultCacheConfiguration));
            return this.withInitialCacheConfigurations(cacheConfigMap);
        }

        public RedisCacheManagerBuilder withInitialCacheConfigurations(Map<String, RedisCacheConfiguration> cacheConfigurations) {
            Assert.notNull(cacheConfigurations, (String)"CacheConfigurations must not be null!");
            cacheConfigurations.forEach((cacheName, configuration) -> Assert.notNull((Object)configuration, (String)String.format("RedisCacheConfiguration for cache %s must not be null!", cacheName)));
            this.intialCaches.putAll(cacheConfigurations);
            return this;
        }

        public RedisCacheManager build() {
            RedisCacheManager cm = new RedisCacheManager(this.cacheWriter, this.defaultCacheConfiguration, this.intialCaches);
            cm.setTransactionAware(this.enableTransactions);
            return cm;
        }
    }
}

