/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.AbstractOperations;
import org.springframework.data.redis.core.ConvertingCursor;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;

class DefaultHashOperations<K, HK, HV>
extends AbstractOperations<K, Object>
implements HashOperations<K, HK, HV> {
    DefaultHashOperations(RedisTemplate<K, ?> template) {
        super(template);
    }

    @Override
    public HV get(K key, Object hashKey) {
        byte[] rawHashKey;
        byte[] rawKey = this.rawKey(key);
        byte[] rawHashValue = this.execute(arg_0 -> DefaultHashOperations.lambda$get$0(rawKey, rawHashKey = this.rawHashKey(hashKey), arg_0), true);
        return rawHashValue != null ? (HV)this.deserializeHashValue(rawHashValue) : null;
    }

    @Override
    public Boolean hasKey(K key, Object hashKey) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawHashKey = this.rawHashKey(hashKey);
        return this.execute(connection -> connection.hExists(rawKey, rawHashKey), true);
    }

    @Override
    public Long increment(K key, HK hashKey, long delta) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawHashKey = this.rawHashKey(hashKey);
        return this.execute(connection -> connection.hIncrBy(rawKey, rawHashKey, delta), true);
    }

    @Override
    public Double increment(K key, HK hashKey, double delta) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawHashKey = this.rawHashKey(hashKey);
        return this.execute(connection -> connection.hIncrBy(rawKey, rawHashKey, delta), true);
    }

    @Override
    public Set<HK> keys(K key) {
        byte[] rawKey = this.rawKey(key);
        Set rawValues = this.execute(connection -> connection.hKeys(rawKey), true);
        return rawValues != null ? this.deserializeHashKeys(rawValues) : Collections.emptySet();
    }

    @Override
    public Long size(K key) {
        byte[] rawKey = this.rawKey(key);
        return this.execute(connection -> connection.hLen(rawKey), true);
    }

    @Override
    @Nullable
    public Long lengthOfValue(K key, HK hashKey) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawHashKey = this.rawHashKey(hashKey);
        return this.execute(connection -> connection.hStrLen(rawKey, rawHashKey), true);
    }

    @Override
    public void putAll(K key, Map<? extends HK, ? extends HV> m) {
        if (m.isEmpty()) {
            return;
        }
        byte[] rawKey = this.rawKey(key);
        LinkedHashMap<byte[], byte[]> hashes = new LinkedHashMap<byte[], byte[]>(m.size());
        for (Map.Entry<HK, HV> entry : m.entrySet()) {
            hashes.put(this.rawHashKey(entry.getKey()), this.rawHashValue(entry.getValue()));
        }
        this.execute(connection -> {
            connection.hMSet(rawKey, hashes);
            return null;
        }, true);
    }

    @Override
    public List<HV> multiGet(K key, Collection<HK> fields) {
        if (fields.isEmpty()) {
            return Collections.emptyList();
        }
        byte[] rawKey = this.rawKey(key);
        byte[][] rawHashKeys = new byte[fields.size()][];
        int counter = 0;
        for (HK hashKey : fields) {
            rawHashKeys[counter++] = this.rawHashKey(hashKey);
        }
        List rawValues = this.execute(connection -> connection.hMGet(rawKey, rawHashKeys), true);
        return this.deserializeHashValues(rawValues);
    }

    @Override
    public void put(K key, HK hashKey, HV value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawHashKey = this.rawHashKey(hashKey);
        byte[] rawHashValue = this.rawHashValue(value);
        this.execute(connection -> {
            connection.hSet(rawKey, rawHashKey, rawHashValue);
            return null;
        }, true);
    }

    @Override
    public Boolean putIfAbsent(K key, HK hashKey, HV value) {
        byte[] rawKey = this.rawKey(key);
        byte[] rawHashKey = this.rawHashKey(hashKey);
        byte[] rawHashValue = this.rawHashValue(value);
        return this.execute(connection -> connection.hSetNX(rawKey, rawHashKey, rawHashValue), true);
    }

    @Override
    public List<HV> values(K key) {
        byte[] rawKey = this.rawKey(key);
        List rawValues = this.execute(connection -> connection.hVals(rawKey), true);
        return rawValues != null ? this.deserializeHashValues(rawValues) : Collections.emptyList();
    }

    @Override
    public Long delete(K key, Object ... hashKeys) {
        byte[] rawKey = this.rawKey(key);
        byte[][] rawHashKeys = this.rawHashKeys(hashKeys);
        return this.execute(connection -> connection.hDel(rawKey, rawHashKeys), true);
    }

    @Override
    public Map<HK, HV> entries(K key) {
        byte[] rawKey = this.rawKey(key);
        Map entries = this.execute(connection -> connection.hGetAll(rawKey), true);
        return entries != null ? this.deserializeHashMap(entries) : Collections.emptyMap();
    }

    @Override
    public Cursor<Map.Entry<HK, HV>> scan(K key, ScanOptions options) {
        byte[] rawKey = this.rawKey(key);
        return this.template.executeWithStickyConnection(connection -> new ConvertingCursor(connection.hScan(rawKey, options), new Converter<Map.Entry<byte[], byte[]>, Map.Entry<HK, HV>>(){

            public Map.Entry<HK, HV> convert(final Map.Entry<byte[], byte[]> source) {
                return new Map.Entry<HK, HV>(){

                    @Override
                    public HK getKey() {
                        return DefaultHashOperations.this.deserializeHashKey((byte[])source.getKey());
                    }

                    @Override
                    public HV getValue() {
                        return DefaultHashOperations.this.deserializeHashValue((byte[])source.getValue());
                    }

                    @Override
                    public HV setValue(HV value) {
                        throw new UnsupportedOperationException("Values cannot be set when scanning through entries.");
                    }
                };
            }
        }));
    }

    private static /* synthetic */ byte[] lambda$get$0(byte[] rawKey, byte[] rawHashKey, RedisConnection connection) throws DataAccessException {
        return connection.hGet(rawKey, rawHashKey);
    }
}

