/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import io.lettuce.core.Limit;
import io.lettuce.core.Range;
import io.lettuce.core.XAddArgs;
import io.lettuce.core.XReadArgs;
import io.lettuce.core.cluster.api.async.RedisClusterAsyncCommands;
import io.lettuce.core.cluster.api.sync.RedisClusterCommands;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Function;
import lombok.NonNull;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.lettuce.LettuceConnection;
import org.springframework.data.redis.connection.lettuce.LettuceConverters;
import org.springframework.data.redis.connection.lettuce.LettuceResult;
import org.springframework.data.redis.connection.lettuce.RangeConverter;
import org.springframework.data.redis.connection.lettuce.StreamConverters;
import org.springframework.data.redis.connection.stream.ByteRecord;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.MapRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.connection.stream.StreamReadOptions;
import org.springframework.util.Assert;

class LettuceStreamCommands
implements RedisStreamCommands {
    @NonNull
    private final LettuceConnection connection;

    @Override
    public Long xAck(byte[] key, String group, RecordId ... recordIds) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.hasText((String)group, (String)"Group name must not be null or empty!");
        Assert.notNull((Object)recordIds, (String)"recordIds must not be null!");
        String[] ids = LettuceStreamCommands.entryIdsToString(recordIds);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xack((Object)key, (Object)LettuceConverters.toBytes(group), ids)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xack((Object)key, (Object)LettuceConverters.toBytes(group), ids)));
                return null;
            }
            return this.getConnection().xack((Object)key, (Object)LettuceConverters.toBytes(group), ids);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public RecordId xAdd(MapRecord<byte[], byte[], byte[]> record) {
        Assert.notNull(record.getStream(), (String)"Stream must not be null!");
        Assert.notNull(record, (String)"Record must not be null!");
        XAddArgs args = new XAddArgs();
        args.id(record.getId().getValue());
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xadd(record.getStream(), args, (Map)record.getValue()), RecordId::of));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xadd(record.getStream(), args, (Map)record.getValue()), RecordId::of));
                return null;
            }
            return RecordId.of(this.getConnection().xadd(record.getStream(), args, (Map)record.getValue()));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long xDel(byte[] key, RecordId ... recordIds) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)recordIds, (String)"recordIds must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xdel((Object)key, LettuceStreamCommands.entryIdsToString(recordIds))));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xdel((Object)key, LettuceStreamCommands.entryIdsToString(recordIds))));
                return null;
            }
            return this.getConnection().xdel((Object)key, LettuceStreamCommands.entryIdsToString(recordIds));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public String xGroupCreate(byte[] key, String groupName, ReadOffset readOffset) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.hasText((String)groupName, (String)"Group name must not be null or empty!");
        Assert.notNull((Object)readOffset, (String)"ReadOffset must not be null!");
        try {
            XReadArgs.StreamOffset streamOffset = XReadArgs.StreamOffset.from((Object)key, (String)readOffset.getOffset());
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xgroupCreate(streamOffset, (Object)LettuceConverters.toBytes(groupName))));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xgroupCreate(streamOffset, (Object)LettuceConverters.toBytes(groupName))));
                return null;
            }
            return this.getConnection().xgroupCreate(streamOffset, (Object)LettuceConverters.toBytes(groupName));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean xGroupDelConsumer(byte[] key, Consumer consumer) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)consumer, (String)"Consumer must not be null!");
        try {
            io.lettuce.core.Consumer<byte[]> lettuceConsumer = LettuceStreamCommands.toConsumer(consumer);
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xgroupDelconsumer((Object)key, lettuceConsumer)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xgroupDelconsumer((Object)key, lettuceConsumer)));
                return null;
            }
            return this.getConnection().xgroupDelconsumer((Object)key, lettuceConsumer);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Boolean xGroupDestroy(byte[] key, String groupName) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.hasText((String)groupName, (String)"Group name must not be null or empty!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xgroupDestroy((Object)key, (Object)LettuceConverters.toBytes(groupName))));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xgroupDestroy((Object)key, (Object)LettuceConverters.toBytes(groupName))));
                return null;
            }
            return this.getConnection().xgroupDestroy((Object)key, (Object)LettuceConverters.toBytes(groupName));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long xLen(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xlen((Object)key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xlen((Object)key)));
                return null;
            }
            return this.getConnection().xlen((Object)key);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<ByteRecord> xRange(byte[] key, org.springframework.data.domain.Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        Range lettuceRange = RangeConverter.toRange(range, Function.identity());
        Limit lettuceLimit = LettuceConverters.toLimit(limit);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xrange((Object)key, lettuceRange, lettuceLimit), StreamConverters.byteRecordListConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xrange((Object)key, lettuceRange, lettuceLimit), StreamConverters.byteRecordListConverter()));
                return null;
            }
            return (List)StreamConverters.byteRecordListConverter().convert((Object)this.getConnection().xrange((Object)key, lettuceRange, lettuceLimit));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<ByteRecord> xRead(StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        Assert.notNull((Object)readOptions, (String)"StreamReadOptions must not be null!");
        Assert.notNull(streams, (String)"StreamOffsets must not be null!");
        XReadArgs.StreamOffset<byte[]>[] streamOffsets = LettuceStreamCommands.toStreamOffsets(streams);
        XReadArgs args = StreamConverters.toReadArgs(readOptions);
        if (LettuceStreamCommands.isBlocking(readOptions)) {
            try {
                if (this.isPipelined()) {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncDedicatedConnection().xread(args, streamOffsets), StreamConverters.byteRecordListConverter()));
                    return null;
                }
                if (this.isQueueing()) {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncDedicatedConnection().xread(args, streamOffsets), StreamConverters.byteRecordListConverter()));
                    return null;
                }
                return (List)StreamConverters.byteRecordListConverter().convert((Object)this.getDedicatedConnection().xread(args, streamOffsets));
            }
            catch (Exception ex) {
                throw this.convertLettuceAccessException(ex);
            }
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xread(args, streamOffsets), StreamConverters.byteRecordListConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xread(args, streamOffsets), StreamConverters.byteRecordListConverter()));
                return null;
            }
            return (List)StreamConverters.byteRecordListConverter().convert((Object)this.getConnection().xread(args, streamOffsets));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<ByteRecord> xReadGroup(Consumer consumer, StreamReadOptions readOptions, StreamOffset<byte[]> ... streams) {
        Assert.notNull((Object)consumer, (String)"Consumer must not be null!");
        Assert.notNull((Object)readOptions, (String)"StreamReadOptions must not be null!");
        Assert.notNull(streams, (String)"StreamOffsets must not be null!");
        XReadArgs.StreamOffset<byte[]>[] streamOffsets = LettuceStreamCommands.toStreamOffsets(streams);
        XReadArgs args = StreamConverters.toReadArgs(readOptions);
        io.lettuce.core.Consumer<byte[]> lettuceConsumer = LettuceStreamCommands.toConsumer(consumer);
        if (LettuceStreamCommands.isBlocking(readOptions)) {
            try {
                if (this.isPipelined()) {
                    this.pipeline(this.connection.newLettuceResult(this.getAsyncDedicatedConnection().xreadgroup(lettuceConsumer, args, streamOffsets), StreamConverters.byteRecordListConverter()));
                    return null;
                }
                if (this.isQueueing()) {
                    this.transaction(this.connection.newLettuceResult(this.getAsyncDedicatedConnection().xreadgroup(lettuceConsumer, args, streamOffsets), StreamConverters.byteRecordListConverter()));
                    return null;
                }
                return (List)StreamConverters.byteRecordListConverter().convert((Object)this.getDedicatedConnection().xreadgroup(lettuceConsumer, args, streamOffsets));
            }
            catch (Exception ex) {
                throw this.convertLettuceAccessException(ex);
            }
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xreadgroup(lettuceConsumer, args, streamOffsets), StreamConverters.byteRecordListConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xreadgroup(lettuceConsumer, args, streamOffsets), StreamConverters.byteRecordListConverter()));
                return null;
            }
            return (List)StreamConverters.byteRecordListConverter().convert((Object)this.getConnection().xreadgroup(lettuceConsumer, args, streamOffsets));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public List<ByteRecord> xRevRange(byte[] key, org.springframework.data.domain.Range<String> range, RedisZSetCommands.Limit limit) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(range, (String)"Range must not be null!");
        Assert.notNull((Object)limit, (String)"Limit must not be null!");
        Range lettuceRange = RangeConverter.toRange(range);
        Limit lettuceLimit = LettuceConverters.toLimit(limit);
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult(this.getAsyncConnection().xrevrange((Object)key, lettuceRange, lettuceLimit), StreamConverters.byteRecordListConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult(this.getAsyncConnection().xrevrange((Object)key, lettuceRange, lettuceLimit), StreamConverters.byteRecordListConverter()));
                return null;
            }
            return (List)StreamConverters.byteRecordListConverter().convert((Object)this.getConnection().xrevrange((Object)key, lettuceRange, lettuceLimit));
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    @Override
    public Long xTrim(byte[] key, long count) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xtrim((Object)key, count)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newLettuceResult((Future<?>)this.getAsyncConnection().xtrim((Object)key, count)));
                return null;
            }
            return this.getConnection().xtrim((Object)key, count);
        }
        catch (Exception ex) {
            throw this.convertLettuceAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void pipeline(LettuceResult result) {
        this.connection.pipeline(result);
    }

    private void transaction(LettuceResult result) {
        this.connection.transaction(result);
    }

    RedisClusterAsyncCommands<byte[], byte[]> getAsyncConnection() {
        return this.connection.getAsyncConnection();
    }

    RedisClusterCommands<byte[], byte[]> getConnection() {
        return this.connection.getConnection();
    }

    RedisClusterAsyncCommands<byte[], byte[]> getAsyncDedicatedConnection() {
        return this.connection.getAsyncDedicatedConnection();
    }

    RedisClusterCommands<byte[], byte[]> getDedicatedConnection() {
        return this.connection.getDedicatedConnection();
    }

    private DataAccessException convertLettuceAccessException(Exception ex) {
        return this.connection.convertLettuceAccessException(ex);
    }

    private static boolean isBlocking(StreamReadOptions readOptions) {
        return readOptions.getBlock() != null && readOptions.getBlock() > 0L;
    }

    private static XReadArgs.StreamOffset<byte[]>[] toStreamOffsets(StreamOffset<byte[]>[] streams) {
        return (XReadArgs.StreamOffset[])Arrays.stream(streams).map(it -> XReadArgs.StreamOffset.from(it.getKey(), (String)it.getOffset().getOffset())).toArray(XReadArgs.StreamOffset[]::new);
    }

    private static io.lettuce.core.Consumer<byte[]> toConsumer(Consumer consumer) {
        return io.lettuce.core.Consumer.from((Object)LettuceConverters.toBytes(consumer.getGroup()), (Object)LettuceConverters.toBytes(consumer.getName()));
    }

    private static String[] entryIdsToString(RecordId[] recordIds) {
        if (recordIds.length == 1) {
            return new String[]{recordIds[0].getValue()};
        }
        return (String[])Arrays.stream(recordIds).map(RecordId::getValue).toArray(String[]::new);
    }

    public LettuceStreamCommands(@NonNull LettuceConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        this.connection = connection;
    }
}

